/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.bydaypart;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReport;
import ordermate.database.reports.sales.bydaypart.SalesByDayPartReportParams;
import ordermate.database.sales.SalesItemQuantity;

public abstract class AbstractSalesByDayPartSearcher
extends PropertySearcher<SalesByDayPartReport> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private boolean includeTax;

    public AbstractSalesByDayPartSearcher() {
        super(SalesByDayPartReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    public abstract String getSalesObjectName();

    public void applyParams(SalesByDayPartReportParams params) {
        if (params.getStartDate() != null) {
            this.dateRangeFilter.setStart(params.getStartDate());
        }
        if (params.getEndDate() != null) {
            this.dateRangeFilter.setEnd(params.getEndDate());
        }
        this.includeTax = params.isTaxInclusive();
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayFilterAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public void setIncludeTax(boolean includeTax) {
        this.includeTax = includeTax;
    }

    public boolean isIncludeTax() {
        return this.includeTax;
    }
}

