/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.bydaypart;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractItemSalesByDayPartSearcher;

public class ComboSalesByDayPartSearcher
extends AbstractItemSalesByDayPartSearcher {
    public ComboSalesByDayPartSearcher() {
        this.removeSearchFilter(this.getTradingDayFilterAdapter());
    }

    @Override
    public String getSalesObjectName() {
        return "Combo";
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        String dayPartSelect = DayPartHelper.INSTANCE.getSelectDayPartQuery("sales_item_quantity.creation_time");
        Date start = (Date)this.getDateRangeFilter().getStart();
        Date end = (Date)this.getDateRangeFilter().getEnd();
        ObjectQuery query = Query.select(this.getSalesObjectName(), "sales_type").selectFunc("ic.name AS sales_object").selectFunc("SUM(inv_combo.combo_quantity) AS sales_count").selectFunc("SUM(sales_combo.combo_item_price) AS sales_value").selectFunc(dayPartSelect).from("(" + this.buildComboSalesSubQuery(start, end) + ")", "sales_combo").joinFunction("LEFT JOIN sales_item ON sales_combo.sales_item_id = sales_item.id").joinLeft(SalesItemQuantity.class, SalesItemQuantity.Properties.SALES_LINE_ITEM).joinLeft(TradingDay.class, SalesItemQuantity.Properties.TRADING_DAY).joinFunction("LEFT JOIN (" + this.buildComboQuantitySubQuery(start, end) + ") inv_combo ON inv_combo.siic_id = sales_combo.sales_combo_id").joinFunction("LEFT JOIN inventory_combo ic ON inv_combo.siic_ic = ic.ID").whereFunction("sales_item_quantity.item_state = 'ACTIVE'").whereFunction("sales_item.FK_sales_combo IS NOT NULL").whereFunction("sales_combo.sales_combo_id IS NOT NULL").whereFunction("sales_item.FK_inventory_combo IS NULL").groupBy("day_part").groupBy("sales_object").orderBy("day_part", false).orderBy("sales_object", false);
        if (start != null && end != null) {
            query = query.whereFunction(this.buildDateRangeString(start, end).substring(3));
        }
        if (this.getSalesLocationFilter().hasSearchValue()) {
            query = this.getSalesLocationFilter().addQueryRestriction(query);
        }
        return query;
    }

    private String buildComboSalesSubQuery(Date start, Date end) {
        return "SELECT sales_item.ID AS sales_item_id, sales_item.fk_sales_combo AS sales_combo_id, " + this.getSalesValueSelectString() + " AS combo_item_price, SUM(sales_component.unit_tax * sales_item_quantity.quantity) AS combo_total_tax FROM sales_item_quantity JOIN sales_item ON sales_item_quantity.FK_sales_item = sales_item.ID JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID JOIN finance_trading_day ON sales_item_quantity.FK_finance_trading_day = finance_trading_day.ID WHERE sales_item.fk_sales_combo IS NOT NULL " + this.buildDateRangeString(start, end) + "GROUP BY sales_item.fk_sales_combo";
    }

    private String buildComboQuantitySubQuery(Date start, Date end) {
        return "SELECT siic.ID as siic_id, siic.FK_inventory_combo as siic_ic, siqic.quantity as combo_quantity FROM sales_item_quantity siqic JOIN sales_item siic ON siqic.FK_sales_item = siic.ID JOIN finance_trading_day ON siqic.FK_finance_trading_day = finance_trading_day.ID WHERE siic.FK_inventory_combo is not null " + this.buildDateRangeString(start, end);
    }

    private String buildDateRangeString(Date start, Date end) {
        return start != null && end != null ? "AND finance_trading_day.day BETWEEN '" + DateTimeUtils.getSQLDateFormat().format(start) + "' AND '" + DateTimeUtils.getSQLDateFormat().format(end) + "' " : "";
    }
}

