/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.bydaypart;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.sales.bydaypart.AbstractItemSalesByDayPartSearcher;

public class ItemSalesByDayPartSearcher
extends AbstractItemSalesByDayPartSearcher {
    @Override
    public String getSalesObjectName() {
        return "Item";
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        String dayPartSelect = DayPartHelper.INSTANCE.getSelectDayPartQuery(SalesItemQuantity.Properties.CREATION_TIME.toString());
        return Query.select(this.getSalesObjectName(), "sales_type").selectFunc("CONCAT(inventory_item.Name, ' (', inventory_size.Name, ')') AS sales_object").selectFunc(this.getSalesValueSelectString() + " AS sales_value").sum(SalesItemQuantity.Properties.QUANTITY, "sales_count").selectFunc(dayPartSelect).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItemUnit.Properties.SIZE, InventoryItemSize.Properties.ID).equals(SalesItemQuantity.Properties.ITEM_STATE, "ACTIVE").groupBy("sales_object").groupBy("day_part").orderBy("sales_object", false).orderBy("day_part", false);
    }
}

