/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.misc.ConfigShift;
import ordermate.database.queries.sales.SalesItemQueries;
import ordermate.database.reports.InventoryComboSoldReport;
import ordermate.database.reports.sales.general.ComboSoldReport;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.searchers.reports.ItemSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class ComboSoldReportSearcher
extends PropertySearcher<ComboSoldReport>
implements ItemSearcher<ComboSoldReport>,
DateSearcher<ComboSoldReport> {
    private final PeriodReportAdapter period;
    private final ObjectSearchFilter<InventoryGroup> menuSectionSearch;
    private final MultiOptionSearchFilter comboFilter;
    private final ISingleValueSearchFilter<InventoryProfile> profileFilter;
    private final TimeSearchFilter timeFilter;
    private final MultiOptionSearchFilter terminalSearch;
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionJoinSearchFilter<ConfigShift> shiftFilter;
    private MultiOptionSearchFilter<User> userFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;

    public ComboSoldReportSearcher() {
        this((PeriodReportAdapter)null);
    }

    public ComboSoldReportSearcher(PeriodReportAdapter period) {
        super(ComboSoldReport.class);
        this.menuSectionSearch = new ObjectSearchFilter<InventoryGroup>(InventoryCombo.Properties.MENU_GROUP);
        this.comboFilter = new MultiOptionSearchFilter(InventoryCombo.Properties.ID);
        this.profileFilter = new ObjectSearchFilter<InventoryProfile>(InventoryCombo.Properties.PROFILE);
        this.timeFilter = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.terminalSearch = new MultiOptionSearchFilter(null);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.shiftFilter = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT);
        this.userFilter = new MultiOptionSearchFilter<User>(SalesItemQuantity.Properties.USER);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.dateRangeFilter, null);
        this.period = period;
        this.addSearchFilter(this.menuSectionSearch);
        this.addSearchFilter(this.comboFilter);
        this.addSearchFilter(this.profileFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.userFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return SalesItemQueries.comboItemsSoldQuery();
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery qry = super.getObjectQuery();
        if (this.terminalSearch.hasSearchValue()) {
            qry.whereIn("combo.FK_config_terminal", this.terminalSearch.getSelectedOptions());
        }
        return qry;
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public PeriodReportAdapter getPeriod() {
        return this.period;
    }

    @Override
    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=3)
    public ISingleValueSearchFilter<InventoryGroup> getMenuSectionFilter() {
        return this.menuSectionSearch;
    }

    @Override
    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=8)
    public MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }

    @Override
    @FilterConfig(name="Terminal", dataType=Terminal.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=7)
    public MultiOptionSearchFilter getTerminalFilter() {
        return this.terminalSearch;
    }

    @FilterConfig(name="Time", dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=true, dateType=SQLDateType.TIME, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    @FilterConfig(name="Type", dataType=InventoryCombo.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true)
    public MultiOptionSearchFilter getComboFilter() {
        return this.comboFilter;
    }

    @FilterConfig(name="Profile", dataType=InventoryProfile.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=4)
    public ISingleValueSearchFilter<InventoryProfile> getProfileFilter() {
        return this.profileFilter;
    }

    @FilterConfig(name="Sold By", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true)
    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public InventoryComboSoldReportSearcher createInventoryComboSearcher() {
        return new InventoryComboSoldReportSearcher(this);
    }

    class InventoryComboSoldReportSearcher
    extends PropertySearcher<InventoryComboSoldReport>
    implements ItemSearcher<InventoryComboSoldReport>,
    DateSearcher<InventoryComboSoldReport> {
        private final ComboSoldReportSearcher comboItemSearcher;

        private InventoryComboSoldReportSearcher(ComboSoldReportSearcher comboItemSearcher) {
            super(InventoryComboSoldReport.class);
            this.comboItemSearcher = comboItemSearcher;
            this.addSearchFilter(this.getMenuSectionFilter());
            this.addSearchFilter(this.getTradingDayDateRangeFilter());
            this.addSearchFilter(this.getProfileFilter());
            this.addSearchFilter(this.getShiftFilter());
            this.addSearchFilter(this.getTerminalFilter());
            this.addSearchFilter(this.getTradingDayDateRangeFilter());
            this.addSearchFilter(this.getComboFilter());
        }

        @Override
        protected ObjectQuery getBaseQuery() {
            return SalesItemQueries.combosSoldQuery();
        }

        @Override
        public ISingleValueSearchFilter<InventoryGroup> getMenuSectionFilter() {
            return this.comboItemSearcher.menuSectionSearch;
        }

        @Override
        public MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
            return this.comboItemSearcher.shiftFilter;
        }

        @Override
        public MultiOptionSearchFilter getTerminalFilter() {
            MultiOptionSearchFilter filter = new MultiOptionSearchFilter(SalesItem.Properties.ORIGINAL_TERMINAL);
            filter.setSearchValue(this.comboItemSearcher.terminalSearch.getSearchValue());
            return filter;
        }

        public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
            return this.comboItemSearcher.dateRangeFilter;
        }

        public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
            return this.comboItemSearcher.tradingDayDateRangeAdapter;
        }

        @Override
        public PeriodReportAdapter getPeriod() {
            return this.comboItemSearcher.period;
        }

        public MultiOptionSearchFilter getComboFilter() {
            return this.comboItemSearcher.comboFilter;
        }

        public ISingleValueSearchFilter<InventoryProfile> getProfileFilter() {
            return ComboSoldReportSearcher.this.profileFilter;
        }
    }
}

