/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.queries.sales.SalesItemQueries;
import ordermate.database.reports.sales.general.OptionSoldReport;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class OptionSoldReportSearcher
extends PropertySearcher<OptionSoldReport>
implements DateSearcher<OptionSoldReport> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionSearchFilter optionGroupFilter;
    private MultiOptionSearchFilter sizeFilter;
    private MultiOptionSearchFilter multiInventoryOptionFilter;
    private TimeSearchFilter timeFilter;
    private TextSearchFilter textFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;
    private ObjectSearchFilter<PeriodReportAdapter.StandardPeriod> periodFilter;

    public OptionSoldReportSearcher() {
        this(PeriodReportAdapter.MONTHLY);
    }

    public OptionSoldReportSearcher(PeriodReportAdapter period) {
        super(OptionSoldReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.optionGroupFilter = new MultiOptionSearchFilter<InventoryOptionGroup>(InventoryOption.Properties.OPTION_GROUP);
        this.sizeFilter = new MultiOptionSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.multiInventoryOptionFilter = new MultiOptionSearchFilter<InventoryOption>(SalesOption.Properties.OPTION);
        this.timeFilter = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.textFilter = new TextSearchFilter(InventoryOption.Properties.LABEL);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.dateRangeFilter, null);
        this.periodFilter = new ObjectSearchFilter(null);
        if (period != null) {
            this.periodFilter.setSearchValue(PeriodReportAdapter.StandardPeriod.standardPeriodFor(period));
        }
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.optionGroupFilter);
        this.addSearchFilter(this.sizeFilter);
        this.addSearchFilter(this.multiInventoryOptionFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.textFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return SalesItemQueries.optionSoldQuery();
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Option Groups", dataType=InventoryOptionGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true)
    public MultiOptionSearchFilter getOptionGroupFilter() {
        return this.optionGroupFilter;
    }

    @FilterConfig(name="Size", dataType=InventoryItemSize.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=5)
    public MultiOptionSearchFilter getSizeFilter() {
        return this.sizeFilter;
    }

    @FilterConfig(name="Options", dataType=InventoryOption.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=4)
    public MultiOptionSearchFilter getMultiInventoryOptionFilter() {
        return this.multiInventoryOptionFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=11)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    @FilterConfig(name="Name", dataType=String.class, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public TextSearchFilter getTextFilter() {
        return this.textFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    public PeriodReportAdapter getPeriod() {
        if (this.periodFilter.hasSearchValue()) {
            return ((PeriodReportAdapter.StandardPeriod)((Object)this.periodFilter.getSearchValue())).getPeriod();
        }
        return null;
    }

    @FilterConfig(name="Period", dataType=PeriodReportAdapter.StandardPeriod.class, plural=FilterConfig.Plural.Single, nullAllowed=true, ignore=true, priority=false, sequence=6)
    public SingleValueSearchFilter<PeriodReportAdapter.StandardPeriod> getPeriodFilter() {
        return this.periodFilter;
    }
}

