/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.ConfigShift;
import ordermate.database.queries.sales.SalesItemQueries;
import ordermate.database.reports.sales.general.PlusesSoldReport;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class PlusesSoldReportSearcher
extends PropertySearcher<PlusesSoldReport>
implements DateSearcher<PlusesSoldReport> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private TimeSearchFilter timeSearchFilter;
    private MultiOptionSearchFilter addGroupFilter;
    private MultiOptionSearchFilter<InventoryItemSize> sizeFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private MultiOptionJoinSearchFilter<ConfigShift> shiftFilter;
    private TextSearchFilter textFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;
    private ObjectSearchFilter<PeriodReportAdapter.StandardPeriod> periodFilter;
    private final PeriodReportAdapter period;

    public PlusesSoldReportSearcher() {
        this(PeriodReportAdapter.MONTHLY);
    }

    public PlusesSoldReportSearcher(PeriodReportAdapter period) {
        super(PlusesSoldReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.timeSearchFilter = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.addGroupFilter = new MultiOptionSearchFilter<InventoryAddGroup>(InventoryAdd.Properties.ADD_GROUP);
        this.sizeFilter = new MultiOptionSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.shiftFilter = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT);
        this.textFilter = new TextSearchFilter(InventoryAdd.Properties.LABEL);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.dateRangeFilter, null);
        this.periodFilter = new ObjectSearchFilter(null);
        this.period = period;
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.timeSearchFilter);
        this.addSearchFilter(this.addGroupFilter);
        this.addSearchFilter(this.sizeFilter);
        this.addSearchFilter(this.textFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.addSearchFilter(this.shiftFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return SalesItemQueries.plusesSoldQuery();
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, priority=true, sequence=2)
    public TimeSearchFilter getTimeSearchFilter() {
        return this.timeSearchFilter;
    }

    @FilterConfig(name="Plus Group", dataType=InventoryAddGroup.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=4)
    public MultiOptionSearchFilter getAddGroupFilter() {
        return this.addGroupFilter;
    }

    @FilterConfig(name="Size", dataType=InventoryItemSize.class, plural=FilterConfig.Plural.Multiple, priority=false, sequence=5)
    public MultiOptionSearchFilter getSizeFilter() {
        return this.sizeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, priority=false, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(name="Label Like", dataType=String.class, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public TextSearchFilter getTextFilter() {
        return this.textFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    public PeriodReportAdapter getPeriod() {
        if (this.periodFilter.hasSearchValue()) {
            return ((PeriodReportAdapter.StandardPeriod)((Object)this.periodFilter.getSearchValue())).getPeriod();
        }
        return this.period;
    }

    public SingleValueSearchFilter<PeriodReportAdapter.StandardPeriod> getPeriodFilter() {
        return this.periodFilter;
    }

    public MultiOptionSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }
}

