/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general.itemsold;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.CustomerGroup;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.searchers.reports.ItemSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class ItemSoldReportSearcher
extends PropertySearcher<ItemSoldReport>
implements TradingDayFilteredReportSearcher<ItemSoldReport>,
ItemSearcher<ItemSoldReport>,
DateSearcher<ItemSoldReport> {
    private static ObjectQuery baseQuery;
    private final ObjectJoinSearchFilter<TradingDay> tradingDaySearch;
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearchAdapter;
    private final TimeSearchFilter timeRangeSearch;
    private final MultiOptionSearchFilter menuSectionSearch;
    private final MultiOptionSearchFilter terminalSearch;
    private final MultiOptionSearchFilter salesLocationSearch;
    private final TextSearchFilter itemNameSearch;
    private final MultiOptionSearchFilter customerCategorySearch;
    private final MultiOptionSearchFilter userSearch;
    private final MultiOptionSearchFilter sizeSearch;
    private final MultiOptionSearchFilter accountType;
    private final MultiOptionSearchFilter customerGroupSearch;
    private final MultiOptionJoinSearchFilter<InventoryCategory> categoryFilter;
    private final ISingleValueSearchFilter<String> categoryNameFilter;
    private final MultiOptionJoinSearchFilter shiftFilter;
    private final MultiOptionJoinSearchFilter<String> shiftFilterLabel;
    private ObjectJoinSearchFilter priceLevelFilter;
    private final MultiOptionSearchFilter priceLevelSearch;
    private final ISingleValueSearchFilter<InventoryItemSize> sizeFilter;
    private ObjectJoinSearchFilter customerCategoryJoinFilter;
    private ObjectJoinSearchFilter customerGroupJoinFilter;
    private ObjectJoinSearchFilter sizeJoinFilter;
    private boolean groupItemsByPrice;

    public ItemSoldReportSearcher() {
        super(ItemSoldReport.class);
        this.tradingDaySearch = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{SalesItem.Properties.ACCOUNT}, new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY));
        this.dateRangeFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(SalesItem.Properties.ACCOUNT, Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearchAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.timeRangeSearch = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.menuSectionSearch = new MultiOptionSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.terminalSearch = new MultiOptionSearchFilter<Terminal>(SalesItemQuantity.Properties.TERMINAL);
        this.salesLocationSearch = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.itemNameSearch = new TextSearchFilter(InventoryItem.Properties.LABEL);
        this.customerCategorySearch = new MultiOptionSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY);
        this.userSearch = new MultiOptionSearchFilter<User>(SalesItemQuantity.Properties.USER);
        this.sizeSearch = new MultiOptionSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.accountType = new MultiOptionSearchFilter<AccountType>(Account.Properties.ACCOUNT_TYPE);
        this.customerGroupSearch = new MultiOptionSearchFilter<CustomerGroup>(Customer.Properties.CUSTOMER_GROUP);
        this.categoryFilter = new MultiOptionJoinSearchFilter(InventoryItem.Properties.CATEGORY, InventoryCategory.Properties.ID);
        this.categoryNameFilter = new ObjectJoinSearchFilter<String>(new ObjectSearchFilter(InventoryCategory.Properties.LABEL){

            @Override
            public ObjectQuery addQueryRestriction(ObjectQuery query) {
                if (!this.hasSearchValue()) {
                    return query;
                }
                String searchValue = (String)this.getSearchValue();
                return query.startsWith(this.getProperty(), searchValue);
            }
        }, InventoryItem.Properties.CATEGORY);
        this.shiftFilter = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT);
        this.shiftFilterLabel = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.LABEL);
        this.priceLevelFilter = null;
        this.priceLevelSearch = new MultiOptionSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.sizeFilter = new ObjectSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.customerCategoryJoinFilter = null;
        this.customerGroupJoinFilter = null;
        this.sizeJoinFilter = null;
        this.groupItemsByPrice = false;
        this.addSearchFilter(this.categoryNameFilter);
    }

    public ItemSoldReportSearcher(ObjectQuery baseQuery) {
        this();
        ItemSoldReportSearcher.baseQuery = baseQuery;
    }

    @Override
    protected final ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = ItemSoldReportSearcher.createBaseQuery();
        if (this.groupItemsByPrice) {
            oQuery.groupBy(SalesComponent.Properties.SAVED_UNIT_PRICE);
        }
        return oQuery;
    }

    public static ObjectQuery createBaseQuery() {
        return ItemSoldReportSearcher.createBaseQuery("report_item_sold.", "0");
    }

    protected static ObjectQuery createBaseQuery(String tablePrefix, String defaultId) {
        if (baseQuery != null) {
            return baseQuery.copy();
        }
        return Query.select(InventoryItem.Properties.MENU_GROUP, "'" + tablePrefix + "fk_inventory_group'").selectFunc(defaultId + " AS '" + tablePrefix + "ID'").select(InventoryItemUnit.Properties.ID, "'" + tablePrefix + "unit_id'").select(InventoryItem.Properties.LABEL, "'" + tablePrefix + "inventory_item_name'").select(InventoryItem.Properties.ID, "'" + tablePrefix + "fk_inventory_item'").select(InventoryItem.Properties.CATEGORY, "'" + tablePrefix + "fk_inventory_category'").select(SalesComponent.Properties.LOYALTY_REDEEMED, "'" + tablePrefix + "loyalty_redeemed'").select(InventoryItemUnit.Properties.SIZE, "'" + tablePrefix + "fk_inventory_size'").select(InventoryItemUnit.Properties.PORTION, "'" + tablePrefix + "fk_inventory_portion'").select(SalesItemQuantity.Properties.SHIFT, "'" + tablePrefix + "fk_finance_shift'").select(InventoryGroup.Properties.LABEL, "'" + tablePrefix + "inventory_group_name'").select(InventoryItemSize.Properties.LABEL, "'" + tablePrefix + "inventory_size_name'").select(InventoryItemPortion.Properties.LABEL, "'" + tablePrefix + "inventory_portion_name'").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "total_price'").sumMultiplication(SalesComponent.Properties.UNIT_TAX_AMOUNT, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "total_tax'").sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.PORTION, "'" + tablePrefix + "quantity_sold'").sumMultiplication(SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "account_discount_total'").sumMultiplication(SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "account_surcharge_total'").sumMultiplication(SalesComponent.Properties.ITEM_DISCOUNT_TOTAL, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "item_discount_total'").sumMultiplication(SalesComponent.Properties.ITEM_SURCHARGE_TOTAL, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "item_surcharge_total'").sumMultiplication(SalesComponent.Properties.INGREDIENT_COST_EX_TAX, SalesItemQuantity.Properties.QUANTITY, "'" + tablePrefix + "total_cogs'").selectFunc(" NULL as '" + tablePrefix + "fk_finance_trading_day'").selectFunc(" NULL as '" + tablePrefix + "report_date'").selectFunc(" 0 as '" + tablePrefix + "mod_count'").linkUsing(InventoryItem.Properties.MENU_GROUP).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(InventoryItem.Properties.MENU_GROUP).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).groupBy(InventoryItemUnit.Properties.ID).groupBy(SalesComponent.Properties.LOYALTY_REDEEMED).orderBy(InventoryGroup.Properties.SEQUENCE).orderBy(InventoryGroup.Properties.LABEL).orderBy(InventoryItem.Properties.LABEL).orderBy(InventoryItemUnit.Properties.SIZE).orderBy(InventoryItemUnit.Properties.PORTION).orderBy(SalesComponent.Properties.SAVED_UNIT_PRICE);
    }

    @Override
    public final ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        this.addSearchFilter(this.tradingDaySearch);
        return this.tradingDaySearch;
    }

    @Override
    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        this.addSearchFilter(this.tradingDayDateRangeSearchAdapter);
        return this.dateRangeFilter;
    }

    @Override
    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        this.addSearchFilter(this.tradingDayDateRangeSearchAdapter);
        return this.tradingDayDateRangeSearchAdapter;
    }

    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=4)
    public final MultiOptionSearchFilter getMenuSectionFilter() {
        this.addSearchFilter(this.menuSectionSearch);
        return this.menuSectionSearch;
    }

    @Override
    @FilterConfig(name="Terminal", dataType=Terminal.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=11)
    public final MultiOptionSearchFilter getTerminalFilter() {
        this.addSearchFilter(this.terminalSearch);
        return this.terminalSearch;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=6)
    public final MultiOptionSearchFilter getSalesLocationFilter() {
        this.addSearchFilter(this.salesLocationSearch);
        return this.salesLocationSearch;
    }

    @FilterConfig(name="Name Like", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=3)
    public final ISingleValueSearchFilter getItemNameFilter() {
        this.addSearchFilter(this.itemNameSearch);
        return this.itemNameSearch;
    }

    @FilterConfig(name="Sold By", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=7)
    public final MultiOptionSearchFilter getUserFilter() {
        this.addSearchFilter(this.userSearch);
        return this.userSearch;
    }

    @FilterConfig(name="Account Type", dataType=AccountType.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=10)
    public final MultiOptionSearchFilter getAccountTypeFilter() {
        this.addSearchFilter(this.accountType);
        return this.accountType;
    }

    @FilterConfig(name="Category", dataType=InventoryCategory.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=12)
    public final MultiOptionJoinSearchFilter<InventoryCategory> getCategoryFilter() {
        this.addSearchFilter(this.categoryFilter);
        return this.categoryFilter;
    }

    @Override
    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=5)
    public final MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        this.addSearchFilter(this.shiftFilter);
        return this.shiftFilter;
    }

    public final MultiOptionJoinSearchFilter<String> getShiftFilterLabel() {
        this.addSearchFilter(this.shiftFilterLabel);
        return this.shiftFilterLabel;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public final TimeSearchFilter getSalesTimeRangeFilter() {
        this.addSearchFilter(this.timeRangeSearch);
        return this.timeRangeSearch;
    }

    @FilterConfig(name="Category Like", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public final ISingleValueSearchFilter<String> getCategoryNameFilter() {
        this.addSearchFilter(this.categoryNameFilter);
        return this.categoryNameFilter;
    }

    @Override
    public PeriodReportAdapter getPeriod() {
        return null;
    }

    @FilterConfig(name="Customer Category", dataType=CustomerCategory.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=9)
    public MultiOptionSearchFilter getCustomerCategoryFilter() {
        if (this.customerCategoryJoinFilter == null) {
            this.customerCategoryJoinFilter = new ObjectJoinSearchFilter(this.customerCategorySearch, SalesLineItem.Properties.CUSTOMER);
            this.addSearchFilter(this.customerCategoryJoinFilter);
        }
        return this.customerCategorySearch;
    }

    @FilterConfig(name="Customer Group", dataType=CustomerGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=8)
    public final MultiOptionSearchFilter getCustomerGroupFilter() {
        if (this.customerGroupJoinFilter == null) {
            this.customerGroupJoinFilter = new ObjectJoinSearchFilter(this.customerGroupSearch, SalesLineItem.Properties.CUSTOMER);
            this.addSearchFilter(this.customerGroupJoinFilter);
        }
        this.addSearchFilter(this.customerGroupSearch);
        return this.customerGroupSearch;
    }

    public boolean isGroupItemsByPrice() {
        return this.groupItemsByPrice;
    }

    public void setGroupItemsByPrice(boolean value) {
        this.groupItemsByPrice = value;
    }

    @FilterConfig(name="Price Level", dataType=PriceLevel.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=14)
    public final MultiOptionSearchFilter getPriceLevelFilter() {
        if (this.priceLevelFilter == null) {
            this.priceLevelFilter = new ObjectJoinSearchFilter(this.priceLevelSearch, SalesComponent.Properties.PRICE_LEVEL);
            this.addSearchFilter(this.priceLevelSearch);
        }
        this.addSearchFilter(this.priceLevelSearch);
        return this.priceLevelSearch;
    }

    @FilterConfig(name="Item Size", dataType=InventoryItemSize.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=13)
    public final MultiOptionSearchFilter getSizeFilter() {
        if (this.sizeJoinFilter == null) {
            this.sizeJoinFilter = new ObjectJoinSearchFilter(this.sizeSearch, InventoryItemUnit.Properties.SIZE);
            this.addSearchFilter(this.sizeJoinFilter);
        }
        this.addSearchFilter(this.sizeSearch);
        return this.sizeSearch;
    }

    public boolean hasAnySearchValues() {
        return this.sizeFilter.hasSearchValue() || this.priceLevelFilter != null && this.priceLevelFilter.hasSearchValue() || this.timeRangeSearch.hasSearchValue() || this.menuSectionSearch.hasSearchValue() || this.terminalSearch.hasSearchValue() || this.itemNameSearch.hasSearchValue() || this.userSearch.hasSearchValue() || this.accountType.hasSearchValue() || this.categoryFilter.hasSearchValue() || this.shiftFilter.hasSearchValue() || this.categoryNameFilter.hasSearchValue() || this.salesLocationSearch.hasSearchValue() || this.customerCategoryJoinFilter != null && this.customerCategoryJoinFilter.hasSearchValue() || this.customerGroupJoinFilter != null && this.customerGroupJoinFilter.hasSearchValue();
    }
}

