/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general.itemsold;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class ItemSoldReportSummarySearcher
extends PropertySearcher {
    private final ObjectSearchFilter<TradingDay> tradingDaySearch;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearch;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final ObjectSearchFilter<InventoryGroup> menuSectionSearch;
    private final TextSearchFilter itemNameSearch;
    private final ISingleValueSearchFilter<InventoryItemSize> sizeFilter;

    public ItemSoldReportSummarySearcher() {
        super(ItemSoldReport.class);
        this.tradingDaySearch = new ObjectSearchFilter<TradingDay>(ItemSoldReport.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearch = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(ItemSoldReport.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeSearch);
        this.menuSectionSearch = new ObjectSearchFilter<InventoryGroup>(ItemSoldReport.Properties.INVENTORY_GROUP);
        this.itemNameSearch = new TextSearchFilter(ItemSoldReport.Properties.INVENTORY_ITEM_NAME);
        this.sizeFilter = new ObjectSearchFilter<InventoryItemSize>(ItemSoldReport.Properties.SIZE);
        this.addSearchFilter(this.tradingDaySearch);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.menuSectionSearch);
        this.addSearchFilter(this.itemNameSearch);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(ItemSoldReport.class);
    }
}

