/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general.itemunsold;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemunsold.ItemUnsoldReport;
import ordermate.database.searchers.reports.sales.general.itemunsold.ItemUnsoldReportSearcher;

public class ItemUnsoldReportCompiler {
    private static final String MISSING_TRADING_DAY_QUERY = "SELECT qryTradingDays.ID AS 'finance_trading_day.ID', qryTradingDays.day AS 'finance_trading_day.day', qryTradingDays.time AS 'finance_trading_day.time', qryTradingDays.close_day AS 'finance_trading_day.close_day', qryTradingDays.close_time AS 'finance_trading_day.close_time', qryTradingDays.mod_count AS 'finance_trading_day.mod_count' FROM (SELECT * FROM finance_trading_day WHERE day BETWEEN ? AND ?) AS qryTradingDays LEFT JOIN report_item_sold ON qryTradingDays.ID = report_item_sold.fk_finance_trading_day WHERE report_item_sold.fk_finance_trading_day IS NULL; ";
    private static final String NUM_TRADING_DAYS_OPEN_QUERY = "SELECT COUNT(ID) AS numDaysOpen FROM finance_trading_day WHERE (day BETWEEN ? AND ?) AND close_day IS NULL;";
    private ItemUnsoldReportSearcher searcher;
    private boolean canCreateMissingReports = true;
    private List<ItemUnsoldReport> lastSearchResults;

    public List<ItemUnsoldReport> getLastSearchResults() {
        return this.lastSearchResults;
    }

    public ItemUnsoldReportCompiler() {
        this.searcher = new ItemUnsoldReportSearcher();
    }

    public ItemUnsoldReportCompiler(ItemUnsoldReportSearcher searcher) {
        this.searcher = searcher;
    }

    public ItemUnsoldReportSearcher getSearcher() {
        return this.searcher;
    }

    protected boolean canUsePreDigestedReports(Date startDate, Date endDate) {
        return this.checkForSearcherCriteria() && this.checkForOpenTradingDays(startDate, endDate);
    }

    protected boolean checkForSearcherCriteria() {
        return !this.searcher.hasAnySearchValues();
    }

    protected boolean checkForOpenTradingDays(Date startDate, Date endDate) {
        try {
            Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(NUM_TRADING_DAYS_OPEN_QUERY, new Object[]{startDate, endDate != null ? endDate : startDate});
            if (result.length == 1 && result[0].length == 1) {
                return (Long)result[0][0] == 0L;
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error checking for open trading days in report date range.", (Throwable)ex);
        }
        return false;
    }

    public List<ItemUnsoldReport> compile() {
        return this.compile(false);
    }

    public List<ItemUnsoldReport> compile(boolean raw) {
        TradingDay endTradingDay;
        Date actualEndDate;
        TradingDay explicitDay = this.searcher.getTradingDayFilter().getSearchValue();
        Date start = (Date)this.searcher.getTradingDayDateRangeFilter().getStart();
        Date end = (Date)this.searcher.getTradingDayDateRangeFilter().getEnd();
        Date actualStartDate = explicitDay != null ? explicitDay.getDate() : (Date)this.searcher.getTradingDayDateRangeFilter().getStart();
        Date date = actualEndDate = explicitDay != null ? explicitDay.getDate() : (Date)this.searcher.getTradingDayDateRangeFilter().getEnd();
        if (explicitDay == null && (endTradingDay = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).whereFunction("TIMESTAMP(finance_trading_day.close_day, finance_trading_day.close_time) = ?").toString(), new Object[]{DateTimeUtils.getSQLTimestampFormat().format(end)})) != null) {
            actualEndDate = endTradingDay.getOpenDateTime();
        }
        if ("1".equals(ReportProperty.find(ReportGroup.General, "Use Item Sold Searcher").getValue()) || !this.canUsePreDigestedReports(actualStartDate, actualEndDate)) {
            this.lastSearchResults = this.searcher.search();
            return this.lastSearchResults;
        }
        if (actualStartDate != null && actualEndDate == null) {
            this.lastSearchResults = new ArrayList<ItemUnsoldReport>();
            return this.lastSearchResults;
        }
        if (this.canCreateMissingReports) {
            this.generateMissingReports(actualStartDate, actualEndDate);
        }
        List<ItemUnsoldReport> reports = this.generateData(actualStartDate, actualEndDate, raw);
        this.searcher.getTradingDayFilter().setSearchValue(explicitDay);
        this.searcher.getTradingDayDateRangeFilter().setStart(start);
        this.searcher.getTradingDayDateRangeFilter().setEnd(actualEndDate == null ? end : actualEndDate);
        this.lastSearchResults = reports;
        return reports;
    }

    private List<ItemUnsoldReport> generateData(Date startDate, Date endDate, boolean raw) {
        return PersistenceManager.getObjectList(ItemUnsoldReport.class, this.getBaseQuery(startDate, endDate, raw).toString());
    }

    protected ObjectQuery getBaseQuery(Date startDate, Date endDate, boolean raw) {
        ObjectQuery query = Query.select(ItemUnsoldReport.Properties.ID).select(ItemUnsoldReport.Properties.UNIT_ID);
        if (raw) {
            query.select(ItemUnsoldReport.Properties.QUANTITY_SOLD);
        } else {
            query.sum(ItemUnsoldReport.Properties.QUANTITY_SOLD, "'report_item_unsold.quantity_sold'").groupBy(ItemUnsoldReport.Properties.PORTION).groupBy(ItemUnsoldReport.Properties.SIZE).groupBy(ItemUnsoldReport.Properties.INVENTORY_ITEM_NAME).groupBy(ItemUnsoldReport.Properties.INVENTORY_GROUP);
        }
        query.select(ItemUnsoldReport.Properties.ITEM).select(ItemUnsoldReport.Properties.INVENTORY_GROUP).select(ItemUnsoldReport.Properties.INVENTORY_CATEGORY).select(ItemUnsoldReport.Properties.INVENTORY_ITEM_NAME).select(ItemUnsoldReport.Properties.SIZE).select(ItemUnsoldReport.Properties.PORTION).select(ItemUnsoldReport.Properties.TRADING_DAY).select(ItemUnsoldReport.Properties.REPORT_DATE).select(ItemUnsoldReport.Properties.INVENTORY_GROUP_NAME).select(ItemUnsoldReport.Properties.INVENTORY_PORTION_NAME).select(ItemUnsoldReport.Properties.INVENTORY_SIZE_NAME).select(ItemUnsoldReport.Properties.MOD_COUNT).wherePropertyBetween(ItemUnsoldReport.Properties.REPORT_DATE, startDate, endDate, SQLDateType.DATE).linkUsing(ItemUnsoldReport.Properties.INVENTORY_GROUP);
        return query.orderBy(InventoryGroup.Properties.SEQUENCE).orderBy(InventoryGroup.Properties.LABEL).orderBy(ItemUnsoldReport.Properties.INVENTORY_ITEM_NAME).orderBy(ItemUnsoldReport.Properties.SIZE);
    }

    protected void generateMissingReports(Date startDate, Date endDate) {
        List<TradingDay> missingDays = PersistenceManager.getObjectList(TradingDay.class, MISSING_TRADING_DAY_QUERY, new Object[]{DateTimeUtils.getSQLDateFormat().format(startDate), DateTimeUtils.getSQLDateFormat().format(endDate)});
        for (TradingDay day : missingDays) {
            if (day.isOpen()) continue;
            this.searcher.getTradingDayFilter().setSearchValue(day);
            this.searcher.getTradingDayDateRangeFilter().setStart(null);
            this.searcher.getTradingDayDateRangeFilter().setEnd(null);
            List reports = this.searcher.search();
            for (ItemUnsoldReport report : reports) {
                report.setTradingDay(day);
                report.setReportDate(day.getDate());
                report.save();
            }
        }
    }

    protected boolean isCanCreateMissingReports() {
        return this.canCreateMissingReports;
    }

    protected void setCanCreateMissingReports(boolean canCreateMissingReports) {
        this.canCreateMissingReports = canCreateMissingReports;
    }
}

