/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.general.itemunsold;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.config.CustomerGroup;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemunsold.ItemUnsoldReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.searchers.reports.ItemSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class ItemUnsoldReportSearcher
extends PropertySearcher<ItemUnsoldReport>
implements TradingDayFilteredReportSearcher<ItemUnsoldReport>,
ItemSearcher<ItemUnsoldReport>,
DateSearcher<ItemUnsoldReport> {
    private static ObjectQuery baseQuery;
    private final ObjectJoinSearchFilter<TradingDay> tradingDaySearch;
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeSearchAdapter;
    private final TimeSearchFilter timeRangeSearch;
    private final MultiOptionSearchFilter menuSectionSearch;
    private final MultiOptionSearchFilter terminalSearch;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationSearch;
    private final TextSearchFilter itemNameSearch;
    private final TextSearchFilter quantityMaximumSearch;
    private final TextSearchFilter quantityMinimumSearch;
    private final MultiOptionSearchFilter customerCategorySearch;
    private final MultiOptionSearchFilter userSearch;
    private final MultiOptionSearchFilter sizeSearch;
    private final MultiOptionSearchFilter accountType;
    private final MultiOptionSearchFilter customerGroupSearch;
    private final MultiOptionJoinSearchFilter<InventoryCategory> categoryFilter;
    private final ISingleValueSearchFilter<String> categoryNameFilter;
    private final MultiOptionJoinSearchFilter shiftFilter;
    private final MultiOptionJoinSearchFilter<String> shiftFilterLabel;
    private ObjectJoinSearchFilter priceLevelFilter;
    private final MultiOptionSearchFilter priceLevelSearch;
    private final ISingleValueSearchFilter<InventoryItemSize> sizeFilter;
    private ObjectJoinSearchFilter customerCategoryJoinFilter;
    private ObjectJoinSearchFilter customerGroupJoinFilter;
    private ObjectJoinSearchFilter sizeJoinFilter;
    private boolean groupItemsByPrice;
    private boolean showNeverSoldItems;

    public ItemUnsoldReportSearcher() {
        super(ItemUnsoldReport.class);
        this.tradingDaySearch = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{SalesItem.Properties.ACCOUNT}, new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY));
        this.dateRangeFilter = TradingDayFilteredReportSearcher.Factory.createDateRangeFilter(SalesItem.Properties.ACCOUNT, Account.Properties.TRADING_DAY);
        this.tradingDayDateRangeSearchAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.timeRangeSearch = new TimeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME);
        this.menuSectionSearch = new MultiOptionSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.terminalSearch = new MultiOptionSearchFilter<Terminal>(SalesItemQuantity.Properties.TERMINAL);
        this.salesLocationSearch = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.itemNameSearch = new TextSearchFilter(InventoryItem.Properties.LABEL);
        this.quantityMaximumSearch = new TextSearchFilter(ItemUnsoldReport.Properties.QUANTITY_SOLD);
        this.quantityMinimumSearch = new TextSearchFilter(ItemUnsoldReport.Properties.QUANTITY_SOLD);
        this.customerCategorySearch = new MultiOptionSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY);
        this.userSearch = new MultiOptionSearchFilter<User>(SalesItemQuantity.Properties.USER);
        this.sizeSearch = new MultiOptionSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.accountType = new MultiOptionSearchFilter<AccountType>(Account.Properties.ACCOUNT_TYPE);
        this.customerGroupSearch = new MultiOptionSearchFilter<CustomerGroup>(Customer.Properties.CUSTOMER_GROUP);
        this.categoryFilter = new MultiOptionJoinSearchFilter(InventoryItem.Properties.CATEGORY, InventoryCategory.Properties.ID);
        this.categoryNameFilter = new ObjectJoinSearchFilter<String>(new ObjectSearchFilter(InventoryCategory.Properties.LABEL){

            @Override
            public ObjectQuery addQueryRestriction(ObjectQuery query) {
                if (!this.hasSearchValue()) {
                    return query;
                }
                String searchValue = (String)this.getSearchValue();
                return query.startsWith(this.getProperty(), searchValue);
            }
        }, InventoryItem.Properties.CATEGORY);
        this.shiftFilter = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT);
        this.shiftFilterLabel = new MultiOptionJoinSearchFilter(SalesItemQuantity.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.LABEL);
        this.priceLevelFilter = null;
        this.priceLevelSearch = new MultiOptionSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.sizeFilter = new ObjectSearchFilter<InventoryItemSize>(InventoryItemUnit.Properties.SIZE);
        this.customerCategoryJoinFilter = null;
        this.customerGroupJoinFilter = null;
        this.sizeJoinFilter = null;
        this.groupItemsByPrice = false;
        this.showNeverSoldItems = true;
        this.addSearchFilter(this.categoryNameFilter);
    }

    public ItemUnsoldReportSearcher(ObjectQuery baseQuery) {
        this();
        ItemUnsoldReportSearcher.baseQuery = baseQuery;
    }

    @Override
    protected final ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = this.createBaseQuery("report_item_unsold.", "0");
        return oQuery;
    }

    @Override
    public final ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        this.addSearchFilter(this.tradingDaySearch);
        return this.tradingDaySearch;
    }

    @Override
    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        this.addSearchFilter(this.tradingDayDateRangeSearchAdapter);
        return this.dateRangeFilter;
    }

    @Override
    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        this.addSearchFilter(this.tradingDayDateRangeSearchAdapter);
        return this.tradingDayDateRangeSearchAdapter;
    }

    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=4)
    public final MultiOptionSearchFilter getMenuSectionFilter() {
        this.addSearchFilter(this.menuSectionSearch);
        return this.menuSectionSearch;
    }

    @Override
    @FilterConfig(name="Terminal", dataType=Terminal.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=11)
    public final MultiOptionSearchFilter getTerminalFilter() {
        this.addSearchFilter(this.terminalSearch);
        return this.terminalSearch;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=6)
    public final MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        this.addSearchFilter(this.salesLocationSearch);
        return this.salesLocationSearch;
    }

    @FilterConfig(name="Name Like", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=3)
    public final ISingleValueSearchFilter getItemNameFilter() {
        this.addSearchFilter(this.itemNameSearch);
        return this.itemNameSearch;
    }

    @FilterConfig(name="Sold By", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=7)
    public final MultiOptionSearchFilter getUserFilter() {
        this.addSearchFilter(this.userSearch);
        return this.userSearch;
    }

    @FilterConfig(name="Account Type", dataType=AccountType.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=10)
    public final MultiOptionSearchFilter getAccountTypeFilter() {
        this.addSearchFilter(this.accountType);
        return this.accountType;
    }

    @FilterConfig(name="Category", dataType=InventoryCategory.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=12)
    public final MultiOptionJoinSearchFilter<InventoryCategory> getCategoryFilter() {
        this.addSearchFilter(this.categoryFilter);
        return this.categoryFilter;
    }

    @Override
    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=5)
    public final MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        this.addSearchFilter(this.shiftFilter);
        return this.shiftFilter;
    }

    public final MultiOptionJoinSearchFilter<String> getShiftFilterLabel() {
        this.addSearchFilter(this.shiftFilterLabel);
        return this.shiftFilterLabel;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public final TimeSearchFilter getSalesTimeRangeFilter() {
        this.addSearchFilter(this.timeRangeSearch);
        return this.timeRangeSearch;
    }

    @FilterConfig(name="Category Like", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public final ISingleValueSearchFilter<String> getCategoryNameFilter() {
        this.addSearchFilter(this.categoryNameFilter);
        return this.categoryNameFilter;
    }

    @Override
    public PeriodReportAdapter getPeriod() {
        return null;
    }

    @FilterConfig(name="Customer Category", dataType=CustomerCategory.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=9)
    public MultiOptionSearchFilter getCustomerCategoryFilter() {
        if (this.customerCategoryJoinFilter == null) {
            this.customerCategoryJoinFilter = new ObjectJoinSearchFilter(this.customerCategorySearch, SalesLineItem.Properties.CUSTOMER);
            this.addSearchFilter(this.customerCategoryJoinFilter);
        }
        return this.customerCategorySearch;
    }

    @FilterConfig(name="Customer Group", dataType=CustomerGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=8)
    public final MultiOptionSearchFilter getCustomerGroupFilter() {
        if (this.customerGroupJoinFilter == null) {
            this.customerGroupJoinFilter = new ObjectJoinSearchFilter(this.customerGroupSearch, SalesLineItem.Properties.CUSTOMER);
            this.addSearchFilter(this.customerGroupJoinFilter);
        }
        this.addSearchFilter(this.customerGroupSearch);
        return this.customerGroupSearch;
    }

    public boolean isGroupItemsByPrice() {
        return this.groupItemsByPrice;
    }

    public void setGroupItemsByPrice(boolean value) {
        this.groupItemsByPrice = value;
    }

    @FilterConfig(name="Price Level", dataType=PriceLevel.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=14)
    public final MultiOptionSearchFilter getPriceLevelFilter() {
        if (this.priceLevelFilter == null) {
            this.priceLevelFilter = new ObjectJoinSearchFilter(this.priceLevelSearch, SalesComponent.Properties.PRICE_LEVEL);
            this.addSearchFilter(this.priceLevelSearch);
        }
        this.addSearchFilter(this.priceLevelSearch);
        return this.priceLevelSearch;
    }

    @FilterConfig(name="Item Size", dataType=InventoryItemSize.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=13)
    public final MultiOptionSearchFilter getSizeFilter() {
        if (this.sizeJoinFilter == null) {
            this.sizeJoinFilter = new ObjectJoinSearchFilter(this.sizeSearch, InventoryItemUnit.Properties.SIZE);
            this.addSearchFilter(this.sizeJoinFilter);
        }
        this.addSearchFilter(this.sizeSearch);
        return this.sizeSearch;
    }

    public boolean hasAnySearchValues() {
        return this.sizeFilter.hasSearchValue() || this.priceLevelFilter != null && this.priceLevelFilter.hasSearchValue() || this.timeRangeSearch.hasSearchValue() || this.menuSectionSearch.hasSearchValue() || this.terminalSearch.hasSearchValue() || this.itemNameSearch.hasSearchValue() || this.userSearch.hasSearchValue() || this.accountType.hasSearchValue() || this.categoryFilter.hasSearchValue() || this.shiftFilter.hasSearchValue() || this.categoryNameFilter.hasSearchValue() || this.salesLocationSearch.hasSearchValue() || this.customerCategoryJoinFilter != null && this.customerCategoryJoinFilter.hasSearchValue() || this.customerGroupJoinFilter != null && this.customerGroupJoinFilter.hasSearchValue() || this.quantityMaximumSearch.hasSearchValue() || this.quantityMinimumSearch.hasSearchValue();
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery query = this.getBaseQuery();
        if (OrderMate.LOG.isDebugEnabled()) {
            OrderMate.LOG.debug(this.getClass().getSimpleName() + " query: " + query.copy());
        }
        return query;
    }

    private ObjectQuery createBaseQuery(String tablePrefix, String defaultId) {
        if (baseQuery != null) {
            return baseQuery.copy();
        }
        ObjectQuery query = Query.select(InventoryItem.class).selectFunc("inventory_item.FK_inventory_group as '" + tablePrefix + "fk_inventory_group'").selectFunc(defaultId + " AS '" + tablePrefix + "ID'").selectFunc("inventory_item_unit.ID as '" + tablePrefix + "unit_id'").selectFunc("inventory_item.Name as '" + tablePrefix + "inventory_item_name'").selectFunc("inventory_item.ID as '" + tablePrefix + "fk_inventory_item'").selectFunc("inventory_item.FK_inventory_category as '" + tablePrefix + "fk_inventory_category'").selectFunc("inventory_item_unit.FK_inventory_size as '" + tablePrefix + "fk_inventory_size'").selectFunc("inventory_item_unit.FK_inventory_portion as '" + tablePrefix + "fk_inventory_portion'").selectFunc("inventory_group.Name as '" + tablePrefix + "inventory_group_name'").selectFunc("inventory_size.Name as '" + tablePrefix + "inventory_size_name'").selectFunc("inventory_portion.name as '" + tablePrefix + "inventory_portion_name'").selectFunc("IFNULL(sales_data.quantity_sold,0)  as '" + tablePrefix + "quantity_sold'");
        if (this.groupItemsByPrice) {
            query.selectFunc(" AVG(IFNULL(inventory_unit_price_level_link.Price,0) )  as '" + tablePrefix + "item_price'");
        } else {
            query.selectFunc(" IFNULL(inventory_unit_price_level_link.Price,0)  as '" + tablePrefix + "item_price'");
        }
        query.selectFunc(" inventory_unit_price_level_link.Price - inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate)  - IF (custom_stock_cost IS NULL, SUM(IF (stock_inventory_item_unit.ID IS NULL, 0, stock_inventory_item_unit.Quantity * stock_item.CurrentCost * if(stock_item.tax_included, 1/1.1,1) / stock_item.Quantity)), custom_stock_cost)  as '" + tablePrefix + "gp_value'").selectFunc(" (inventory_unit_price_level_link.Price - inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate) -IF (custom_stock_cost IS NULL, SUM(IF (stock_inventory_item_unit.ID IS NULL, 0, stock_inventory_item_unit.Quantity * stock_item.CurrentCost * if(stock_item.tax_included, 1/1.1,1) / stock_item.Quantity)), custom_stock_cost)) / (inventory_unit_price_level_link.Price - inventory_unit_price_level_link.Price * system_tax_code.rate / ( 1 + system_tax_code.rate) )    as '" + tablePrefix + "gp_percent'").selectFunc(" NULL as '" + tablePrefix + "fk_finance_trading_day'").selectFunc(" NULL as '" + tablePrefix + "report_date'").selectFunc(" 0 as '" + tablePrefix + "mod_count' ").joinFunction("JOIN inventory_item_unit ON inventory_item_unit.FK_inventory_item = inventory_item.ID").joinFunction("JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID").joinFunction("JOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID ").joinFunction("JOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID").joinFunction("JOIN inventory_unit_price_level_link ON inventory_item_unit.ID = inventory_unit_price_level_link.FK_inventory_item_unit  JOIN inventory_price_level ON inventory_unit_price_level_link.FK_inventory_price_level = inventory_price_level.ID  INNER JOIN inventory_item_unit_tax ON inventory_item_unit_tax.fk_inventory_item_unit = inventory_item_unit.ID  INNER JOIN system_tax_code ON inventory_item_unit_tax.FK_system_tax_code = system_tax_code.ID  LEFT JOIN stock_inventory_item_unit ON stock_inventory_item_unit.FK_inventory_item_unit = inventory_item_unit.ID  LEFT JOIN stock_item ON stock_inventory_item_unit.FK_stock_item = stock_item.ID AND stock_item.system_state = 'ACTIVE' ").joinFunction(this.constructSalesQuery());
        query.joinFunction("LEFT JOIN sales_item_quantity on sales_item_quantity.id=sales_data.fk_sales_item_quantity");
        query.joinFunction("LEFT JOIN sales_component on sales_component.id=sales_data.fk_sales_component");
        if (this.shiftFilter.hasSearchValue()) {
            query.joinFunction("LEFT JOIN finance_shift on sales_item_quantity.fk_finance_shift=finance_shift.id").whereIn("finance_shift.FK_config_shift", this.shiftFilter.getSelectedOptions());
        }
        if (this.salesLocationSearch.hasSearchValue()) {
            query = query.joinFunction("LEFT JOIN config_terminal_location on sales_item_quantity.fk_config_terminal_location=config_terminal_location.id").whereIn("config_terminal_location.id", this.salesLocationSearch.getSelectedOptions());
        }
        query.whereFunction("inventory_item.system_state='ACTIVE'");
        if (this.itemNameSearch.hasSearchValue()) {
            query.whereFunction("inventory_item.Name LIKE '%" + this.itemNameSearch.getSearchValue().toString() + "%'");
        }
        if (this.menuSectionSearch.hasSearchValue()) {
            query.whereIn("inventory_item.fk_inventory_group", this.menuSectionSearch.getSelectedOptions());
        }
        if (this.categoryFilter.hasSearchValue()) {
            query.whereIn("inventory_item.FK_inventory_category", this.categoryFilter.getSelectedOptions());
        }
        if (this.sizeFilter.hasSearchValue()) {
            query.whereFunction("inventory_item_unit.FK_inventory_size=" + this.sizeFilter.getSearchValue());
        }
        if (this.priceLevelSearch.hasSearchValue()) {
            query.whereIn("inventory_price_level.id ", this.priceLevelSearch.getSelectedOptions());
        }
        if (this.accountType.hasSearchValue()) {
            query.whereIn("sales_data.account_type", this.accountType.getSelectedOptions());
        }
        if (this.userSearch.hasSearchValue()) {
            query.whereIn("sales_data.fk_config_user", this.userSearch.getSelectedOptions());
        }
        if (this.terminalSearch.hasSearchValue()) {
            query.whereIn("sales_data.fk_config_terminal", this.terminalSearch.getSelectedOptions());
        }
        query.groupBy("inventory_item_unit.ID, inventory_item.ID");
        if (this.groupItemsByPrice) {
            query.groupBy("sales_component.unit_price, sales_component.unit_price");
        }
        query.orderBy("inventory_group.sequence, inventory_group.Name, inventory_item.Name, inventory_item_unit.FK_inventory_size, inventory_item_unit.FK_inventory_portion", false);
        return query;
    }

    private String constructTradingDayRangeString() {
        Date start = (Date)this.dateRangeFilter.getStart();
        Date end = (Date)this.dateRangeFilter.getEnd();
        if (start == null || end == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = dateFormat.format(start);
        String endDate = dateFormat.format(end);
        return " where (finance_trading_day.day  BETWEEN '" + startDate + "' AND '" + endDate + "')";
    }

    public boolean isShowNeverSoldItems() {
        return this.showNeverSoldItems;
    }

    public void setShowNeverSoldItems(boolean showNeverSoldItems) {
        this.showNeverSoldItems = showNeverSoldItems;
    }

    private String constructSalesQuery() {
        BigDecimal quantityMaximum = BigDecimal.ZERO;
        BigDecimal quantityMinimum = BigDecimal.ZERO;
        if (this.quantityMaximumSearch.hasSearchValue()) {
            quantityMaximum = new BigDecimal(this.quantityMaximumSearch.getSearchValue().toString());
        }
        if (this.quantityMinimumSearch.hasSearchValue()) {
            quantityMinimum = new BigDecimal(this.quantityMinimumSearch.getSearchValue().toString());
        }
        String salesQuery = quantityMinimum.compareTo(BigDecimal.ZERO) > 0 ? " INNER JOIN " : " LEFT JOIN ";
        salesQuery = salesQuery + "(SELECT inventory_item_unit.ID AS unit_id, inventory_item.ID AS item_id,sales_account.account_type AS account_type,sales_item_quantity.fk_config_user AS fk_config_user,sales_item_quantity.fk_config_terminal AS fk_config_terminal,SUM(IFNULL(sales_item_quantity.quantity * sales_component.portion,0)) AS quantity_sold,sales_item_quantity.id as fk_sales_item_quantity,sales_component.id as fk_sales_component FROM inventory_item_unit JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID JOIN sales_component ON sales_component.FK_inventory_item_unit = inventory_item_unit.ID JOIN sales_item ON sales_component.FK_sales_item = sales_item.ID JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID JOIN finance_trading_day ON sales_account.FK_finance_trading_day = finance_trading_day.ID " + this.constructTradingDayRangeString() + " GROUP BY inventory_item_unit.ID, inventory_item.ID ";
        salesQuery = salesQuery + "Having SUM(IFNULL(sales_item_quantity.quantity * sales_component.portion,0)) between " + quantityMinimum + " and " + quantityMaximum + ") AS sales_data  ON inventory_item_unit.ID = sales_data.unit_id AND inventory_item.ID = sales_data.item_id";
        return salesQuery;
    }

    @FilterConfig(name="Quantity Maximum", dataType=Double.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=15)
    public TextSearchFilter getQuantityMaximumSearch() {
        return this.quantityMaximumSearch;
    }

    @FilterConfig(name="Quantity Minimum", dataType=Double.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=16)
    public TextSearchFilter getQuantityMinimumSearch() {
        return this.quantityMinimumSearch;
    }
}

