/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.offset.DateOffsetFunctions;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.reports.sales.staff.AbstractStaffSoldReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.users.User;

public abstract class AbstractStaffSoldReportSearcher<T extends AbstractStaffSoldReport>
extends PropertySearcher<T>
implements TradingDayFilteredReportSearcher<T> {
    private final ObjectSearchFilter<TradingDay> tradingDaySearchFilter;
    private TimeSearchFilter salesTimeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final FixedRangeSearchFilter<Date> fixedRangeFilter;
    private MultiOptionSearchFilter userFilter;
    private MultiOptionJoinSearchFilter shiftFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;

    public AbstractStaffSoldReportSearcher(Class<T> clazz) {
        super(clazz);
        this.tradingDaySearchFilter = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.salesTimeFilter = new TimeSearchFilter(Account.Properties.CREATION_DATE_TIME);
        this.tradingDayRangeFilter = new RangeJoinSearchFilter<Date>(new PropertiedObject.Property[]{Account.Properties.TRADING_DAY}, new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP));
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayRangeFilter);
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.tradingDayRangeFilter, DateOffsetFunctions.END_DAY);
        this.userFilter = new MultiOptionSearchFilter<User>(SalesItemQuantity.Properties.USER);
        this.shiftFilter = new MultiOptionJoinSearchFilter(Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        Date now = new Date();
        this.tradingDayRangeFilter.setStart(now);
        this.tradingDayRangeFilter.setEnd(now);
        this.fixedRangeFilter.setSearchValue(now);
        this.addSearchFilter(this.salesTimeFilter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.userFilter);
        this.addSearchFilter(this.tradingDaySearchFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.fixedRangeFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayRangeFilter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDaySearchFilter;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public TimeSearchFilter getTimeFilter() {
        return this.salesTimeFilter;
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, where="active = 1 AND hidden = 0", order="Surname, Firstname", priority=true, sequence=4)
    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, priority=false, sequence=6)
    public MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = this.createInitialQuery();
        this.addSelectTotal(query);
        this.addSelectQuantity(query);
        this.addSelects(query);
        this.addLinking(query);
        this.addOrdering(query);
        this.addGrouping(query);
        return query;
    }

    protected ObjectQuery createInitialQuery() {
        return Query.select(User.Properties.FIRST_NAME, StaffReportColumn.FIRSTNAME.col).select(User.Properties.LAST_NAME, StaffReportColumn.LASTNAME.col).selectFunc(this.getReferenceColumn() + " as fk_ref");
    }

    protected void addSelectTotal(ObjectQuery query) {
        query.sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.TOTAL.col);
    }

    protected void addSelectQuantity(ObjectQuery query) {
        query.sum(SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.QUANTITY.col);
    }

    protected abstract String getReferenceColumn();

    protected void addOrdering(ObjectQuery query) {
        query.orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME);
    }

    protected void addGrouping(ObjectQuery query) {
        query.groupBy(this.getReferenceColumn()).groupBy(User.Properties.ID);
    }

    protected abstract void addSelects(ObjectQuery var1);

    protected void addLinking(ObjectQuery query) {
        query.linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM);
    }
}

