/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.reports.sales.staff.StaffCategorySoldReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;

public class StaffCategoryReportSearcher
extends AbstractStaffSoldReportSearcher<StaffCategorySoldReport> {
    private MultiOptionSearchFilter<InventoryCategory> catFilter;

    public StaffCategoryReportSearcher() {
        super(StaffCategorySoldReport.class);
        this.catFilter = new MultiOptionSearchFilter<InventoryCategory>(InventoryItem.Properties.CATEGORY);
        this.addSearchFilter(this.catFilter);
    }

    @Override
    protected String getReferenceColumn() {
        return InventoryItem.Properties.CATEGORY.toString();
    }

    @Override
    protected void addSelects(ObjectQuery query) {
        query.select(InventoryCategory.Properties.LABEL, StaffReportColumn.NAME.col);
    }

    @Override
    protected void addOrdering(ObjectQuery query) {
        query.orderBy(InventoryCategory.Properties.LABEL);
        super.addOrdering(query);
    }

    @Override
    protected void addLinking(ObjectQuery query) {
        super.addLinking(query);
        query.linkUsing(InventoryItem.Properties.CATEGORY).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(SalesItem.Properties.ACCOUNT);
    }

    @FilterConfig(name="Category", dataType=InventoryCategory.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=6)
    public MultiOptionSearchFilter getCategoryFilter() {
        return this.catFilter;
    }
}

