/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.reports.sales.staff.StaffComboSoldReport;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;

public class StaffComboReportSearcher
extends AbstractStaffSoldReportSearcher<StaffComboSoldReport> {
    private boolean isQtyReport;
    private MultiOptionSearchFilter comboTypeFilter;

    public StaffComboReportSearcher() {
        super(StaffComboSoldReport.class);
        this.comboTypeFilter = new MultiOptionSearchFilter<InventoryCombo>(SalesCombo.Properties.COMBO);
        this.addSearchFilter(this.comboTypeFilter);
    }

    @Override
    protected String getReferenceColumn() {
        if (this.isQtyReport) {
            return SalesCombo.Properties.COMBO.toString();
        }
        return "combo.fk_inventory_combo";
    }

    @Override
    protected void addOrdering(ObjectQuery query) {
        query.orderBy(InventoryCombo.Properties.LABEL);
        super.addOrdering(query);
    }

    @Override
    protected void addSelects(ObjectQuery query) {
        query.lastFrom("sales_item").select(InventoryCombo.Properties.LABEL, StaffReportColumn.NAME.col);
    }

    @Override
    protected void addLinking(ObjectQuery query) {
        query.joinFunction("JOIN sales_item combo ON combo.ID = sales_item.fk_sales_combo ");
        query.joinFunction("JOIN inventory_combo ON combo.FK_inventory_combo = inventory_combo.id ", InventoryCombo.class);
        super.addLinking(query);
        query.linkUsing(SalesItem.Properties.ACCOUNT);
    }

    @Override
    protected void addSelectQuantity(ObjectQuery query) {
        query.selectFunc("0.0 as " + StaffReportColumn.QUANTITY.col);
    }

    @Override
    public List<StaffComboSoldReport> search() {
        this.isQtyReport = false;
        this.comboTypeFilter.setPropertyString("combo.fk_inventory_combo");
        List<StaffComboSoldReport> firstList = super.search();
        List<StaffComboSoldReport> secondList = this.createQuantityReport();
        this.isQtyReport = false;
        return this.mergeReports(firstList, secondList);
    }

    protected List<StaffComboSoldReport> createQuantityReport() {
        this.isQtyReport = true;
        this.comboTypeFilter.setPropertyString(null);
        ObjectQuery query = this.createInitialQuery();
        query.selectFunc("0.0 as total");
        super.addSelectQuantity(query);
        this.addSelects(query);
        query.linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItem.Properties.ACCOUNT).joinFunction("JOIN inventory_combo ON sales_item.FK_inventory_combo = inventory_combo.id ", InventoryCombo.class).joinFunction("JOIN sales_item_quantity ON sales_item.ID = sales_item_quantity.fk_sales_item ", SalesItemQuantity.class).not().isNull(SalesCombo.Properties.COMBO);
        this.addOrdering(query);
        this.addGrouping(query);
        this.addSearchFilterRestrictions(query);
        return PersistenceManager.getObjectList(StaffComboSoldReport.class, query.toString());
    }

    protected List<StaffComboSoldReport> mergeReports(List<StaffComboSoldReport> totalList, List<StaffComboSoldReport> qtyList) {
        if (totalList.size() != qtyList.size()) {
            throw new IllegalStateException("We should have exactly the same number of rows.");
        }
        for (int i = 0; i < qtyList.size(); ++i) {
            StaffComboSoldReport report = totalList.get(i);
            report.setQuantity(qtyList.get(i).getQuantity());
        }
        return totalList;
    }

    @FilterConfig(name="Combo", dataType=InventoryCombo.class, nullAllowed=true, plural=FilterConfig.Plural.Multiple, priority=true, sequence=3)
    public MultiOptionSearchFilter getComboTypeFilter() {
        return this.comboTypeFilter;
    }
}

