/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.queries.sales.StaffItemReportQueries;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;

public class StaffDeletionReportSearcher
extends AbstractStaffSoldReportSearcher<StaffDeletedItemsReport> {
    private SingleValueQuerySearchFilter itemSearcher;

    public StaffDeletionReportSearcher() {
        super(StaffDeletedItemsReport.class);
        this.itemSearcher = new MultiOptionSearchFilter(InventoryItemUnit.Properties.ID){

            @Override
            public void setSearchValue(Object value) {
                if (value instanceof List) {
                    if (!((List)value).isEmpty() && ((List)value).get(0) instanceof ItemSummary) {
                        List summaryList = (List)value;
                        if (summaryList != null) {
                            ArrayList<InventoryItemUnit> unitList = new ArrayList<InventoryItemUnit>();
                            for (ItemSummary summary : summaryList) {
                                unitList.add(summary.getInventoryItemUnitObject());
                            }
                            super.setSearchValue(unitList);
                        }
                    } else {
                        super.setSearchValue(value);
                    }
                }
            }
        };
        this.addSearchFilter(this.itemSearcher);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return StaffItemReportQueries.deletedItemsSummaryQuery();
    }

    @Override
    protected String getReferenceColumn() {
        return "sales_item.fk_inventory_item";
    }

    @Override
    protected void addOrdering(ObjectQuery query) {
        query.orderBy(Account.Properties.CREATION_DATE_TIME).orderBy(SalesItemQuantity.Properties.USER);
        super.addOrdering(query);
    }

    @Override
    protected void addSelects(ObjectQuery query) {
        query.select(Account.Properties.CREATION_DATE_TIME, StaffReportColumn.CREATION_TIME.col).select(InventoryItem.Properties.LABEL, StaffReportColumn.NAME.col).select(InventoryItemSize.Properties.LABEL, StaffReportColumn.SIZE.col).select(InventoryItemPortion.Properties.LABEL, StaffReportColumn.PORTION.col);
    }

    @Override
    protected void addLinking(ObjectQuery query) {
        query.linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION);
        super.addLinking(query);
    }

    public SingleValueQuerySearchFilter getItemSearchFilter() {
        return this.itemSearcher;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery query = super.getObjectQuery();
        return query;
    }
}

