/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.staff;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.reports.sales.staff.StaffGroupSoldReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;

public class StaffGroupReportSearcher
extends AbstractStaffSoldReportSearcher<StaffGroupSoldReport> {
    private MultiOptionSearchFilter groupFilter;

    public StaffGroupReportSearcher() {
        super(StaffGroupSoldReport.class);
        this.groupFilter = new MultiOptionSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.addSearchFilter(this.groupFilter);
    }

    @Override
    protected String getReferenceColumn() {
        return InventoryItem.Properties.MENU_GROUP.toString();
    }

    @Override
    protected void addSelects(ObjectQuery query) {
        query.select(InventoryGroup.Properties.LABEL, StaffReportColumn.NAME.col);
    }

    @Override
    protected void addOrdering(ObjectQuery query) {
        query.orderBy(InventoryGroup.Properties.LABEL);
        super.addOrdering(query);
    }

    @Override
    protected void addLinking(ObjectQuery query) {
        super.addLinking(query);
        query.linkUsing(InventoryItem.Properties.MENU_GROUP).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(SalesItem.Properties.ACCOUNT);
    }

    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=3)
    public MultiOptionSearchFilter getGroupFilter() {
        return this.groupFilter;
    }
}

