/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.fragments.Fragment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.reports.sales.time.SalesByTimeReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.adjustments.AbstractCombosAsDiscountCombobulator;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.stock.DecrementStockArea;
import ordermate.database.stock.DecrementStockAreaInventoryItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.usage.PersistentStockUsage;

public class SalesByTimeSearcher
extends PropertySearcher<SalesByTimeReport>
implements DateSearcher<SalesByTimeReport> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final ISingleValueSearchFilter<StockArea> stockAreaFilter;
    private final ISingleValueSearchFilter<SalesLocation> locationFilter;

    public SalesByTimeSearcher() {
        super(SalesByTimeReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.stockAreaFilter = new ObjectSearchFilter<StockArea>(PersistentStockUsage.Properties.STOCK_AREA);
        this.locationFilter = new ObjectSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.locationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        if (this.stockAreaFilter.hasSearchValue()) {
            ObjectQuery query = this.getCoreQuery();
            query.select(StockArea.Properties.ID, "stockarea_id").select(StockArea.Properties.LABEL, "stockarea_label").lastFrom("config_terminal");
            query.select(SalesLocation.Properties.LABEL, "location").groupBy(SalesLocation.Properties.LABEL).selectFunc("SUM(inventory_item_unit.num_patrons * sales_item_quantity.quantity * sales_component.portion) AS num_patrons");
            new SalesByTimeCoreFragment().apply(query);
            new SalesByTimePatronsFragment().apply(query);
            new SalesByTimeStockAreaFilterFragment().apply(query);
            query.groupBy("HOUR(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("DAYOFWEEK(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("DAYOFMONTH(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("MONTH(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("YEAR(" + SalesItemQuantity.Properties.CREATION_TIME + ")");
            return query;
        }
        ObjectQuery query = this.getCoreQuery();
        query.selectFunc("0 AS stockarea_Id").selectFunc("'' AS stockarea_label");
        if (DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            query.select(SalesLocation.Properties.LABEL, "location").groupBy(SalesLocation.Properties.LABEL).linkUsing(SalesItemQuantity.Properties.SALES_LOCATION, SalesLocation.Properties.ID).selectFunc("SUM(inventory_item_unit.num_patrons * sales_item_quantity.quantity * sales_component.portion) AS num_patrons").linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID);
        } else {
            query.selectFunc("0 AS num_patrons").select(SalesLocation.Properties.LABEL, "location").linkUsing(SalesItemQuantity.Properties.SALES_LOCATION, SalesLocation.Properties.ID).union(this.getAccountPatronsQuery());
        }
        query.linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).groupBy("HOUR(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("DAYOFWEEK(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("DAYOFMONTH(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("MONTH(" + SalesItemQuantity.Properties.CREATION_TIME + ")").groupBy("YEAR(" + SalesItemQuantity.Properties.CREATION_TIME + ")");
        return query;
    }

    private ObjectQuery getCoreQuery() {
        ObjectQuery query = Query.sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total_sales").selectFunc("sum(" + SalesComponent.Properties.SAVED_UNIT_PRICE + " * " + SalesItemQuantity.Properties.QUANTITY + ") - sum(" + SalesComponent.Properties.UNIT_TAX_AMOUNT + " * " + SalesItemQuantity.Properties.QUANTITY + ") as total_Ex_Tax").selectFunc("IFNULL(SUM(" + SalesComponent.Properties.ITEM_DISCOUNT_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "+ " + SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "),0.0) AS total_discounts").selectFunc("IFNULL(SUM(" + SalesComponent.Properties.ITEM_SURCHARGE_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "+ " + SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL + " * " + SalesItemQuantity.Properties.QUANTITY + "),0.0) AS total_surcharges").selectFunc("HOUR(" + SalesItemQuantity.Properties.CREATION_TIME + ") AS from_time").selectFunc("HOUR(" + SalesItemQuantity.Properties.CREATION_TIME + ") + 1 AS to_time").select(SalesItemQuantity.Properties.CREATION_TIME, "date");
        return query;
    }

    private ObjectQuery getAccountPatronsQuery() {
        ObjectQuery patronsQuery = Query.selectFunc("0 AS total_sales").selectFunc("0 as total_ex_tax").selectFunc("0 as total_discounts").selectFunc("0 as total_surcharges").selectFunc("HOUR(" + Account.Properties.CREATION_DATE_TIME + ") AS from_time").selectFunc("HOUR(" + Account.Properties.CREATION_DATE_TIME + ") + 1 AS to_time").select(Account.Properties.CREATION_DATE_TIME, "date").selectFunc("0 AS stockarea_Id").selectFunc("'' AS stockarea_label").sum(Account.Properties.NUM_PATRONS, "num_patrons").selectFunc("'' AS location").groupBy("HOUR(" + Account.Properties.CREATION_DATE_TIME + ")").groupBy("DAYOFWEEK(" + Account.Properties.CREATION_DATE_TIME + ")").groupBy("DAYOFMONTH(" + Account.Properties.CREATION_DATE_TIME + ")").groupBy("MONTH(" + Account.Properties.CREATION_DATE_TIME + ")").groupBy("YEAR(" + Account.Properties.CREATION_DATE_TIME + ")");
        if (this.dateRangeFilter.hasSearchValue()) {
            patronsQuery.wherePropertyBetween(Account.Properties.CREATION_DATE_TIME, (Date)this.dateRangeFilter.getStart(), (Date)this.dateRangeFilter.getEnd(), SQLDateType.TIMESTAMP);
        }
        return patronsQuery;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public ISingleValueSearchFilter<StockArea> getStockAreaFilter() {
        return this.stockAreaFilter;
    }

    public ISingleValueSearchFilter<SalesLocation> getLocationFilter() {
        return this.locationFilter;
    }

    @Override
    public List<SalesByTimeReport> search() {
        List<SalesByTimeReport> salesList = super.search();
        if (!DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            salesList = this.getMergedSalesReportsList(salesList);
        }
        if (SystemProperty.getInstance().isCombosAsDiscount()) {
            salesList = this.applyComboDiscountAdjustments(salesList);
        }
        return salesList;
    }

    private List<SalesByTimeReport> getMergedSalesReportsList(List<SalesByTimeReport> salesList) {
        HashMap<String, SalesByTimeReport> salesResultsMap = new HashMap<String, SalesByTimeReport>();
        for (SalesByTimeReport salesReport : salesList) {
            String key = this.getKeyFor(salesReport);
            if (salesResultsMap.containsKey(key)) {
                ((SalesByTimeReport)salesResultsMap.get(key)).add(salesReport);
                continue;
            }
            salesResultsMap.put(key, salesReport);
        }
        ArrayList<SalesByTimeReport> result = new ArrayList<SalesByTimeReport>(salesResultsMap.values());
        Collections.sort(result);
        return result;
    }

    private String getKeyFor(SalesByTimeReport salesReport) {
        return salesReport.getFromTime() + salesReport.getToTime() + DateTimeUtils.getMediumDateFormat().format(salesReport.getDate());
    }

    private List<SalesByTimeReport> applyComboDiscountAdjustments(List<SalesByTimeReport> sales) {
        AbstractCombosAsDiscountCombobulator<SalesByTimeReport> combobulator = this.createCombobulator();
        for (SalesByTimeReport sale : sales) {
            combobulator.setReport(sale);
            combobulator.combobulateReport();
        }
        return sales;
    }

    private AbstractCombosAsDiscountCombobulator<SalesByTimeReport> createCombobulator() {
        return new AbstractCombosAsDiscountCombobulator<SalesByTimeReport>(){

            @Override
            public void applySearchFilters() {
                if (SalesByTimeSearcher.this.stockAreaFilter.hasSearchValue()) {
                    new SalesByTimeStockAreaFilterFragment().apply(this.searcher.getObjectQuery());
                }
                this.searcher.getDateRangeFilter().setStart(((SalesByTimeReport)this.report).getDate());
                this.searcher.getDateRangeFilter().setEnd(((SalesByTimeReport)this.report).getDate());
                Calendar start = Calendar.getInstance();
                DateTimeUtils.clearTimePart(start);
                start.set(11, ((SalesByTimeReport)this.report).getFromTime());
                this.searcher.getTimeRangeFilter().setStart(start);
                Calendar end = Calendar.getInstance();
                DateTimeUtils.clearTimePart(end);
                end.set(11, ((SalesByTimeReport)this.report).getToTime());
                this.searcher.getTimeRangeFilter().setEnd(end);
            }

            @Override
            public void addToSalesExDiscountsTotal(Price toAdd) {
            }

            @Override
            public void addToDiscountsTotal(Price toAdd) {
                ((SalesByTimeReport)this.report).setTotalDiscounts(((SalesByTimeReport)this.report).getTotalDiscounts().add(toAdd));
            }
        };
    }

    private class SalesByTimeStockAreaFilterFragment
    implements Fragment {
        private SalesByTimeStockAreaFilterFragment() {
        }

        @Override
        public ObjectQuery apply(ObjectQuery query) {
            query.whereFunction("stock_area.ID = " + ((StockArea)SalesByTimeSearcher.this.stockAreaFilter.getSearchValue()).getID());
            query.joinFunction("LEFT JOIN stock_area_terminal_item ON stock_area_terminal_item.FK_config_terminal = config_terminal.ID AND stock_area_terminal_item.FK_inventory_item = inventory_item.ID ", DecrementStockAreaInventoryItem.class).joinFunction("LEFT JOIN stock_area_terminal_menugroup ON stock_area_terminal_menugroup.FK_config_terminal = config_terminal.ID AND stock_area_terminal_menugroup.FK_inventory_group = inventory_group.ID", DecrementStockArea.class).joinFunction("JOIN stock_area ON ((stock_area_terminal_item.FK_stock_area IS NULL AND stock_area_terminal_menugroup.FK_stock_area IS NULL AND config_terminal.FK_stock_area = stock_area.ID ) OR  (stock_area_terminal_item.FK_stock_area IS NULL AND stock_area_terminal_menugroup.FK_stock_area = stock_area.ID) OR stock_area_terminal_item.FK_stock_area = stock_area.ID)", StockArea.class);
            return query;
        }
    }

    private class SalesByTimePatronsFragment
    implements Fragment {
        private SalesByTimePatronsFragment() {
        }

        @Override
        public ObjectQuery apply(ObjectQuery query) {
            query.linkUsing(SalesItem.Properties.ORIGINAL_TERMINAL, Terminal.Properties.ID).linkUsing(SalesItemQuantity.Properties.SALES_LOCATION, SalesLocation.Properties.ID).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID);
            return query;
        }
    }

    private class SalesByTimeCoreFragment
    implements Fragment {
        private SalesByTimeCoreFragment() {
        }

        @Override
        public ObjectQuery apply(ObjectQuery query) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            query.joinFunction("JOIN sales_item ON sales_item.FK_config_terminal = config_terminal.ID", SalesItem.class).joinFunction("JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item_quantity.creation_time >= '" + sdf.format(((Date)SalesByTimeSearcher.this.dateRangeFilter.getStart()).getTime()) + "' AND sales_item_quantity.creation_time <= '" + sdf.format(((Date)SalesByTimeSearcher.this.dateRangeFilter.getEnd()).getTime()) + "'", SalesItemQuantity.class).joinFunction("JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID", SalesComponent.class).joinFunction("JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID", SalesComponent.class).joinFunction("JOIN inventory_category ON inventory_item.FK_inventory_category = inventory_category.ID", InventoryItem.class).joinFunction("JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID", InventoryItem.class);
            return query;
        }
    }
}

