/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.search.offset.AbstractDateOffsetFunction;
import au.com.ordermate.search.offset.DateOffsetEndAdapter;
import au.com.ordermate.search.offset.DateOffsetFunctions;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ordermate.OrderMate;
import ordermate.database.reports.sales.time.SalesHistoryReport;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportSearcher;

public class SalesHistoryReportAggregator {
    private SalesHistoryReportSearcher searcher;
    private final AbstractDateOffsetFunction endPeriodOffset;
    private AbstractDateOffsetFunction fullOffset;

    public SalesHistoryReportAggregator(SalesHistoryReportSearcher searcher) {
        this.searcher = searcher;
        this.endPeriodOffset = (AbstractDateOffsetFunction)searcher.getPeriod().getDateOffset();
        this.fullOffset = this.getFullOffset();
    }

    private AbstractDateOffsetFunction getFullOffset() {
        return this.endPeriodOffset == DateOffsetFunctions.END_WEEK_ENDING ? new WeekEndingFullDateOffsetFunction() : new DateOffsetEndAdapter(this.endPeriodOffset);
    }

    public List<SalesHistoryReport> setOffset(List<SalesHistoryReport> list) {
        for (SalesHistoryReport report : list) {
            if (report == null) continue;
            report.setOffset(this.searcher.getPeriod().getDateOffset());
        }
        return list;
    }

    public List<SalesHistoryReport> insertEmptyDates(IRangedQuerySearchFilter<Date> dateFilter, List<SalesHistoryReport> reports) {
        int direction;
        if (dateFilter.getStart() == null || dateFilter.getEnd() == null) {
            OrderMate.LOG.info("No dates to filter, aggregation not required");
            return reports;
        }
        Date start = (Date)dateFilter.getStart();
        Date end = (Date)dateFilter.getEnd();
        Map<Date, SalesHistoryReport> reportMap = this.coalesceRepeatingPeriods(reports);
        if (start.after(end) && !this.endPeriodOffset.isBackwards() || start.before(end) && this.endPeriodOffset.isBackwards()) {
            Date temp = start;
            start = end;
            end = temp;
        }
        start = this.endPeriodOffset.calcStart(start);
        end = this.endPeriodOffset.calcStart(this.endPeriodOffset.calcOffset(end));
        int n = direction = this.endPeriodOffset.isBackwards() ? -1 : 1;
        while (start.compareTo(end) * direction <= 0) {
            if (!reportMap.containsKey(start)) {
                reportMap.put(start, new SalesHistoryReport(this.endPeriodOffset, start, Price.ZERO_DOLLAR));
            }
            start = this.fullOffset.calcOffset(start);
        }
        return new ArrayList<SalesHistoryReport>(reportMap.values());
    }

    private Map<Date, SalesHistoryReport> coalesceRepeatingPeriods(List<SalesHistoryReport> searchResults) {
        TreeMap<Date, SalesHistoryReport> reportMap = new TreeMap<Date, SalesHistoryReport>();
        for (SalesHistoryReport report : searchResults) {
            Date key = report.getPeriodStartDate();
            if (reportMap.containsKey(key)) {
                SalesHistoryReport existing = (SalesHistoryReport)reportMap.get(key);
                Date lastSale = this.getLatestLastSale(report, existing);
                Price salesValue = existing.getSalesValue().add(report.getSalesValue());
                reportMap.put(key, new SalesHistoryReport(this.endPeriodOffset, lastSale, salesValue));
                continue;
            }
            reportMap.put(key, report);
        }
        return reportMap;
    }

    private Date getLatestLastSale(SalesHistoryReport report, SalesHistoryReport existing) {
        Date lastSale = existing.getLastSale();
        Date newLastSale = report.getLastSale();
        lastSale = newLastSale.after(lastSale) ? newLastSale : lastSale;
        return lastSale;
    }

    private static class WeekEndingFullDateOffsetFunction
    extends AbstractDateOffsetFunction {
        public WeekEndingFullDateOffsetFunction() {
            super(5, -7);
        }

        @Override
        public Calendar calcStart(Calendar pointWithinRange) {
            while (pointWithinRange.get(7) != 1) {
                pointWithinRange.add(7, 1);
            }
            return pointWithinRange;
        }

        public String toString() {
            return "Week Ending";
        }
    }
}

