/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.SearchHelper;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SQLFunctionSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.sales.SalesHistoryQueries;
import ordermate.database.reports.sales.time.SalesHistoryReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.searchers.reports.DateSearcher;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.time.SalesHistoryReportAggregator;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class SalesHistoryReportSearcher
extends PropertySearcher<SalesHistoryReport>
implements TradingDayFilteredReportSearcher<SalesHistoryReport>,
DateSearcher<SalesHistoryReport> {
    private DateRangeSearchFilter dateRangeSearchFilter;
    private IRangedQuerySearchFilter<Date> tradingDayRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private ISingleValueSearchFilter<TradingDay> tradingDayFilter;
    private MultiOptionJoinSearchFilter<ConfigShift> shiftFilter;
    private MultiOptionSearchFilter<Customer> customerFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private ISingleValueSearchFilter<CustomerCategory> customerTypeFilter;
    private final ISingleValueSearchFilter<Boolean> includeEmptyDatesFilter;
    private boolean includeEmptyDates;
    private PeriodReportAdapter period;
    private ObjectSearchFilter<PeriodReportAdapter.StandardPeriod> periodFilter;
    private SQLFunctionSearchFilter dayOfWeekFilter;
    private SQLFunctionSearchFilter weekFilter;
    private SQLFunctionSearchFilter monthFilter;
    private SQLFunctionSearchFilter quarterFilter;

    public SalesHistoryReportSearcher(PeriodReportAdapter period) {
        super(SalesHistoryReport.class);
        this.dateRangeSearchFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        this.tradingDayRangeFilter = new RangeJoinSearchFilter<Date>(new PropertiedObject.Property[]{Account.Properties.TRADING_DAY}, this.dateRangeSearchFilter);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeSearchFilter);
        this.tradingDayFilter = TradingDayFilteredReportSearcher.Factory.createTradingDayFilter(TradingDay.Properties.ID);
        this.shiftFilter = new MultiOptionJoinSearchFilter(Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        this.customerFilter = new MultiOptionSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.customerTypeFilter = new ObjectJoinSearchFilter<CustomerCategory>(new PropertiedObject.Property[]{Account.Properties.CUSTOMER}, new ObjectSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY));
        this.includeEmptyDatesFilter = new BooleanSearchFilter(null);
        this.includeEmptyDates = true;
        this.periodFilter = new ObjectSearchFilter(null);
        this.dayOfWeekFilter = new SQLFunctionSearchFilter(SQLPeriodFunction.DAYOFWEEK, TradingDay.Properties.DATE);
        this.weekFilter = new SQLFunctionSearchFilter(SQLPeriodFunction.WEEK, TradingDay.Properties.DATE);
        this.monthFilter = new SQLFunctionSearchFilter(SQLPeriodFunction.MONTH, TradingDay.Properties.DATE);
        this.quarterFilter = new SQLFunctionSearchFilter(SQLPeriodFunction.QUARTER, TradingDay.Properties.DATE);
        this.period = period;
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.customerFilter);
        this.addSearchFilter(this.customerTypeFilter);
        this.addSearchFilter(this.dayOfWeekFilter);
        this.addSearchFilter(this.weekFilter);
        this.addSearchFilter(this.monthFilter);
        this.addSearchFilter(this.quarterFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    public void initIncludeEmptyDatesFilterValue() {
        this.includeEmptyDates = this.getIncludeEmptyDatesFilterValue();
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return SalesHistoryQueries.salesByPeriodQuery(this.getPeriod());
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayRangeFilter;
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeSearchFilter;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @Override
    public String getDisplayableDate() {
        Date date = null;
        if (this.tradingDayRangeFilter.hasSearchValue()) {
            date = (Date)this.tradingDayRangeFilter.getStart();
        } else if (this.tradingDayFilter.hasSearchValue()) {
            date = this.tradingDayFilter.getSearchValue().getDate();
        }
        return this.getPeriod().formatDateForDisplay(date);
    }

    public PeriodReportAdapter getPeriod() {
        if (this.periodFilter.hasSearchValue()) {
            return ((PeriodReportAdapter.StandardPeriod)((Object)this.periodFilter.getSearchValue())).getPeriod();
        }
        return this.period;
    }

    @Override
    public List<SalesHistoryReport> search() {
        SalesHistoryReportAggregator aggregator = new SalesHistoryReportAggregator(this);
        if (this.getTradingDayDateRangeFilter().hasSearchValue()) {
            SearchHelper.setWidestDateRange(this.dateRangeSearchFilter, this.getPeriod());
            List<SalesHistoryReport> reports = aggregator.setOffset(super.search());
            if (this.includeEmptyDates) {
                reports = aggregator.insertEmptyDates(this.dateRangeSearchFilter, reports);
            }
            return reports;
        }
        return aggregator.setOffset(super.search());
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=6)
    public MultiOptionSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(name="Include Empty Dates", plural=FilterConfig.Plural.Single, dataType=Boolean.class, nullAllowed=true, priority=true, sequence=3)
    public ISingleValueSearchFilter<Boolean> getIncludeEmptyDatesFilter() {
        return this.includeEmptyDatesFilter;
    }

    @FilterConfig(name="Customer", dataType=Customer.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, makerName="Customer Details")
    public MultiOptionSearchFilter getCustomerFilter() {
        return this.customerFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=15)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @FilterConfig(name="Customer Category", dataType=CustomerCategory.class, plural=FilterConfig.Plural.Single, priority=false, sequence=5)
    public ISingleValueSearchFilter<CustomerCategory> getCustomerTypeFilter() {
        return this.customerTypeFilter;
    }

    public boolean getIncludeEmptyDates() {
        return this.includeEmptyDates;
    }

    public void setIncludeEmptyDates(boolean includeEmptyDates) {
        this.includeEmptyDates = includeEmptyDates;
    }

    public SQLFunctionSearchFilter getDayOfWeekFilter() {
        return this.dayOfWeekFilter;
    }

    public SQLFunctionSearchFilter getWeekFilter() {
        return this.weekFilter;
    }

    public SQLFunctionSearchFilter getMonthFilter() {
        return this.monthFilter;
    }

    public SQLFunctionSearchFilter getQuarterFilter() {
        return this.quarterFilter;
    }

    public void setPeriod(PeriodReportAdapter value) {
        this.period = value;
    }

    public boolean getIncludeEmptyDatesFilterValue() {
        Boolean value = this.includeEmptyDatesFilter.getSearchValue();
        if (value == null) {
            return false;
        }
        return value;
    }

    @FilterConfig(name="Period", dataType=PeriodReportAdapter.StandardPeriod.class, plural=FilterConfig.Plural.Single, priority=true, sequence=2, defaultValue="Daily")
    public ObjectSearchFilter<PeriodReportAdapter.StandardPeriod> getPeriodFilter() {
        return this.periodFilter;
    }
}

