/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time;

import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.PeriodAggregatorStrategy;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.PeriodAggregatorStrategyFactory;

public class SalesYearOnYearReportAggregator {
    private SQLPeriodFunction group;
    private PeriodAggregatorStrategy periodStrategy;

    public SalesYearOnYearReportAggregator(SQLPeriodFunction group) {
        this.group = group;
    }

    public void aggregate(List<SalesYearOnYearReport> resultList, IRangedQuerySearchFilter<Date> filter) {
        PeriodAggregatorStrategyFactory factory = new PeriodAggregatorStrategyFactory();
        this.periodStrategy = factory.getStrategy(this.group, filter);
        this.periodStrategy.alignStartOfPeriod(resultList);
        this.periodStrategy.populateMissingData(resultList);
        this.fillInPrevious(resultList);
    }

    protected void fillInPrevious(List<SalesYearOnYearReport> resultList) {
        SalesYearOnYearReport previous = null;
        for (SalesYearOnYearReport result : resultList) {
            result.setDiffToPrevious(previous);
            previous = result;
        }
    }
}

