/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reports.AccountTotalsReportQuery;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.YearOnYearPeriod;
import ordermate.database.searchers.reports.sales.time.SalesYearOnYearReportAggregator;

public class SalesYearOnYearReportSearcher
extends PropertySearcher<SalesYearOnYearReport> {
    private SQLPeriodFunction group;
    private ISingleValueSearchFilter<InventoryGroup> menuSectionFilter;
    private MultiOptionSearchFilter terminalFilter;
    private ISingleValueSearchFilter<String> shiftFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final ISingleValueSearchFilter<List<Long>> tradingDayIdFilter;
    private final TimeSearchFilter timeFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private MultiOptionSearchFilter customerFilter;
    private ISingleValueSearchFilter<CustomerCategory> customerTypeFilter;
    private FixedRangeSearchFilter<Date> fixedRangeFilter;
    private ISingleValueSearchFilter<PriceLevel> priceLevelFilter;
    private SalesYearOnYearReportAggregator aggregator;

    public SalesYearOnYearReportSearcher(SQLPeriodFunction group) {
        super(SalesYearOnYearReport.class);
        this.menuSectionFilter = new ObjectJoinSearchFilter<InventoryGroup>(new PropertiedObject.Property[]{SalesComponent.Properties.INVENTORY_ITEM}, new ObjectSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP));
        this.terminalFilter = new MultiOptionSearchFilter<Terminal>(SalesItemQuantity.Properties.TERMINAL);
        this.shiftFilter = new ObjectJoinSearchFilter<String>(new PropertiedObject.Property[]{Account.Properties.SHIFT}, new ObjectSearchFilter<String>(Shift.Properties.NAME));
        this.tradingDayDateFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateFilter);
        this.tradingDayIdFilter = new ObjectJoinSearchFilter<List<Long>>(new MultiOptionSearchFilter(TradingDay.Properties.ID), Account.Properties.TRADING_DAY);
        this.timeFilter = new TimeSearchFilter(Account.Properties.CREATION_DATE_TIME);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.customerFilter = new MultiOptionSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.customerTypeFilter = new ObjectJoinSearchFilter<CustomerCategory>(new PropertiedObject.Property[]{Account.Properties.CUSTOMER}, new ObjectSearchFilter<CustomerCategory>(Customer.Properties.CATEGORY));
        this.fixedRangeFilter = new FixedRangeSearchFilter<Date>(this.tradingDayDateFilter, null);
        this.priceLevelFilter = new ObjectSearchFilter<PriceLevel>(SalesComponent.Properties.PRICE_LEVEL);
        if (group == null) {
            throw new IllegalArgumentException("Group must be provided");
        }
        if (!this.isSalesYearOnYearFunction(group)) {
            throw new IllegalArgumentException("Group must be one of DAY, WEEK, MONTH, QUARTER");
        }
        this.group = group;
        this.aggregator = new SalesYearOnYearReportAggregator(group);
        this.addSearchFilter(this.menuSectionFilter);
        this.addSearchFilter(this.terminalFilter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.timeFilter);
        this.addSearchFilter(this.tradingDayIdFilter);
        this.addSearchFilter(this.customerFilter);
        this.addSearchFilter(this.customerTypeFilter);
        this.addSearchFilter(this.priceLevelFilter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    private boolean isSalesYearOnYearFunction(SQLPeriodFunction grp) {
        return YearOnYearPeriod.PeriodType.isValidFunction(grp);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return AccountTotalsReportQuery.getObjectQuery().clearSelect().sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "total").selectFunc("MIN(TIMESTAMP(" + TradingDay.Properties.DATE + ", " + TradingDay.Properties.TIME + ")) AS 'period'").groupBy(SQLPeriodFunction.YEAR, "TIMESTAMP(finance_trading_day.day, finance_trading_day.time)");
    }

    @Override
    public ObjectQuery getObjectQuery() {
        ObjectQuery query = super.getObjectQuery();
        return query;
    }

    private ObjectQuery addWhere(ObjectQuery query) {
        if (this.group == SQLPeriodFunction.DAY) {
            query.whereFunction((Object)((Object)SQLPeriodFunction.WEEK) + "(TIMESTAMP(" + TradingDay.Properties.DATE + ", " + TradingDay.Properties.TIME + "),2) = " + (Object)((Object)SQLPeriodFunction.WEEK) + "(" + this.getSQLDate() + ",2)").whereFunction((Object)((Object)SQLPeriodFunction.DAYOFWEEK) + "(" + TradingDay.Properties.DATE + ") = " + (Object)((Object)SQLPeriodFunction.DAYOFWEEK) + "(" + this.getSQLDate() + ")");
        } else if (this.group == SQLPeriodFunction.WEEK) {
            query.whereFunction((Object)((Object)this.group) + "(" + TradingDay.Properties.DATE + ",2) = " + (Object)((Object)this.group) + "(" + this.getSQLDate() + ",2)");
        } else {
            query.whereFunction((Object)((Object)this.group) + "(" + TradingDay.Properties.DATE + ") = " + (Object)((Object)this.group) + "(" + this.getSQLDate() + ")");
        }
        return query;
    }

    private String getSQLDate() {
        return "'" + DateTimeUtils.getSQLTimestampFormat().format((Date)this.tradingDayDateRangeAdapter.getStart()) + "'";
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.tradingDayDateFilter;
    }

    public ISingleValueSearchFilter<InventoryGroup> getMenuSectionFilter() {
        return this.menuSectionFilter;
    }

    public MultiOptionSearchFilter getTerminalFilter() {
        return this.terminalFilter;
    }

    public ISingleValueSearchFilter<String> getShiftFilter() {
        return this.shiftFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateFilter;
    }

    public TimeSearchFilter getTimeFilter() {
        return this.timeFilter;
    }

    public ISingleValueSearchFilter<List<Long>> getTradingDayIdFilter() {
        return this.tradingDayIdFilter;
    }

    public MultiOptionSearchFilter getCustomerFilter() {
        return this.customerFilter;
    }

    public ISingleValueSearchFilter<CustomerCategory> getCustomerTypeFilter() {
        return this.customerTypeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public FixedRangeSearchFilter<Date> getFixedRangeFilter() {
        return this.fixedRangeFilter;
    }

    public ISingleValueSearchFilter<PriceLevel> getPriceLevelFilter() {
        return this.priceLevelFilter;
    }

    @Override
    public List<SalesYearOnYearReport> search() {
        List<NumberReport> tradingDayIds = PersistenceManager.getObjectList(NumberReport.class, this.addWhere(Query.select(TradingDay.Properties.ID, "value")).toString());
        ArrayList<Long> ids = new ArrayList<Long>();
        for (NumberReport report : tradingDayIds) {
            ids.add(report.getValue());
        }
        if (ids.isEmpty()) {
            return new ArrayList<SalesYearOnYearReport>();
        }
        this.tradingDayIdFilter.setSearchValue(ids);
        if (!this.getTradingDayDateRangeFilter().hasSearchValue()) {
            return Collections.emptyList();
        }
        List<SalesYearOnYearReport> resultList = super.search();
        this.aggregator.aggregate(resultList, this.getTradingDayDateRangeFilter());
        return resultList;
    }

    @Override
    public boolean hasSearchValues() {
        return super.hasSearchValues() || this.tradingDayDateFilter.hasSearchValue();
    }
}

