/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.PeriodAggregatorStrategy;

public abstract class AbstractPeriodAggregatorStrategy
implements PeriodAggregatorStrategy {
    private SalesYearOnYearReportDateComparator dateSort = new SalesYearOnYearReportDateComparator();
    private Date periodSearchValue;

    public AbstractPeriodAggregatorStrategy(IRangedQuerySearchFilter<Date> searchFilter) {
        this.periodSearchValue = this.getPeriodSearchedOn(searchFilter);
    }

    protected abstract Date getPeriodSearchedOn(IRangedQuerySearchFilter<Date> var1);

    @Override
    public void alignStartOfPeriod(List<SalesYearOnYearReport> resultList) {
        for (SalesYearOnYearReport result : resultList) {
            this.performOffsetFunction(result);
        }
    }

    protected abstract void performOffsetFunction(SalesYearOnYearReport var1);

    @Override
    public void populateMissingData(List<SalesYearOnYearReport> resultList) {
        Collections.sort(resultList, this.dateSort);
        for (Date year : TradingDay.ReportDates.getStartYearDates()) {
            if (this.yearExists(year, resultList)) continue;
            SalesYearOnYearReport entry = new SalesYearOnYearReport();
            entry.setPeriod(this.calculatePeriodForMissingYear(year, this.getPeriodSearchValue()));
            resultList.add(entry);
        }
        Collections.sort(resultList, this.dateSort);
    }

    protected abstract Date calculatePeriodForMissingYear(Date var1, Date var2);

    private boolean yearExists(Date year, List<SalesYearOnYearReport> resultList) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(year);
        Calendar cal2 = Calendar.getInstance();
        for (SalesYearOnYearReport report : resultList) {
            cal2.setTime(report.getPeriod());
            if (cal1.get(1) != cal2.get(1)) continue;
            return true;
        }
        return false;
    }

    public Date getPeriodSearchValue() {
        return this.periodSearchValue;
    }

    public void setPeriodSearchValue(Date periodSearchValue) {
        this.periodSearchValue = periodSearchValue;
    }

    private static class SalesYearOnYearReportDateComparator
    implements Comparator<SalesYearOnYearReport> {
        private SalesYearOnYearReportDateComparator() {
        }

        @Override
        public int compare(SalesYearOnYearReport o1, SalesYearOnYearReport o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getPeriod().compareTo(o2.getPeriod());
        }
    }
}

