/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.AbstractPeriodAggregatorStrategy;

public class MonthOfYearPeriodAggregatorStrategy
extends AbstractPeriodAggregatorStrategy {
    public MonthOfYearPeriodAggregatorStrategy(IRangedQuerySearchFilter<Date> searchFilter) {
        super(searchFilter);
    }

    @Override
    protected Date getPeriodSearchedOn(IRangedQuerySearchFilter<Date> searchFilter) {
        return new Date(((Date)searchFilter.getStart()).getTime());
    }

    @Override
    protected void performOffsetFunction(SalesYearOnYearReport result) {
        Calendar firstDayOfPeriod = DateTimeUtils.toCal(result.getPeriod());
        firstDayOfPeriod.set(2, this.getPeriodSearchValue().getMonth());
        firstDayOfPeriod.set(5, 1);
        result.setPeriod(firstDayOfPeriod.getTime());
    }

    @Override
    protected Date calculatePeriodForMissingYear(Date missingYear, Date periodSearchDate) {
        Calendar periodCal = Calendar.getInstance();
        periodCal.setTime(periodSearchDate);
        int month = periodCal.get(2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(missingYear);
        cal.set(2, month);
        return cal.getTime();
    }
}

