/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy;

import au.com.ordermate.oquery.SQLPeriodFunction;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.DayOfYearPeriodAggregatorStrategy;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.MonthOfYearPeriodAggregatorStrategy;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.PeriodAggregatorStrategy;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.WeekOfYearPeriodAggregatorStrategy;

public class PeriodAggregatorStrategyFactory {
    private Map<SQLPeriodFunction, Class> knownDefaultStrategys = new HashMap<SQLPeriodFunction, Class>(){
        {
            this.put(SQLPeriodFunction.DAY, DayOfYearPeriodAggregatorStrategy.class);
            this.put(SQLPeriodFunction.WEEK, WeekOfYearPeriodAggregatorStrategy.class);
            this.put(SQLPeriodFunction.MONTH, MonthOfYearPeriodAggregatorStrategy.class);
            this.put(SQLPeriodFunction.QUARTER, MonthOfYearPeriodAggregatorStrategy.class);
        }
    };

    public PeriodAggregatorStrategy getStrategy(SQLPeriodFunction function, IRangedQuerySearchFilter<Date> filter) {
        Class toBuild = this.knownDefaultStrategys.get((Object)function);
        PeriodAggregatorStrategy newStrat = null;
        try {
            newStrat = (PeriodAggregatorStrategy)toBuild.getDeclaredConstructor(IRangedQuerySearchFilter.class).newInstance(filter);
        }
        catch (Exception e) {
            OrderMate.LOG.error(toBuild + " does not match a constructor of params: " + Date.class);
        }
        return newStrat;
    }
}

