/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.reports.sales.yearonyear.SalesYearOnYearReport;
import ordermate.database.searchers.reports.sales.time.periodaggregatorstrategy.AbstractPeriodAggregatorStrategy;

public class WeekOfYearPeriodAggregatorStrategy
extends AbstractPeriodAggregatorStrategy {
    public WeekOfYearPeriodAggregatorStrategy(IRangedQuerySearchFilter<Date> searchFilter) {
        super(searchFilter);
    }

    @Override
    protected void performOffsetFunction(SalesYearOnYearReport result) {
        Calendar weekifyer = Calendar.getInstance();
        weekifyer.setTime(result.getPeriod());
        weekifyer.setTime(DateTimeUtils.getEndDateForWeek(weekifyer.getTime()));
        result.setPeriod(weekifyer.getTime());
    }

    @Override
    protected Date calculatePeriodForMissingYear(Date missingYear, Date periodSearchDate) {
        Calendar periodCal = Calendar.getInstance();
        periodCal.setTime(periodSearchDate);
        Calendar missingYearCal = Calendar.getInstance();
        missingYearCal.setTime(missingYear);
        Calendar newYearsWeekDay = this.getDayInWeekOfGivenYear(periodCal, missingYearCal.get(1));
        return newYearsWeekDay.getTime();
    }

    protected Calendar getDayInWeekOfGivenYear(Calendar periodCal, int year) {
        Calendar cal = Calendar.getInstance();
        DateTimeUtils.configCalendarWeekDetails(cal, 2, 1);
        cal.set(year, 0, 1);
        Calendar calCopy = Calendar.getInstance();
        calCopy.setTime(cal.getTime());
        while (cal.get(7) != periodCal.get(7)) {
            cal.add(7, 1);
        }
        int diff = this.getMYSQLWeekOfYearDiff(periodCal.getTime(), cal.getTime());
        cal.add(3, diff);
        DateTimeUtils.resetConfigCalendarWeekDetails(cal);
        return cal;
    }

    @Override
    protected Date getPeriodSearchedOn(IRangedQuerySearchFilter<Date> searchFilter) {
        return new Date(((Date)searchFilter.getEnd()).getTime());
    }

    int getMYSQLWeekOfYearDiff(Date date1, Date date2) {
        DateTimeUtils.ThreadLocalDateFormat myFormat = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("yyyy-MM-dd"));
        PersistenceManager.getInstance();
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT WEEK('" + ((DateFormat)myFormat.get()).format(date1.getTime()) + "'), WEEK('" + ((DateFormat)myFormat.get()).format(date2.getTime()) + "')", null);
        int weekDiff = -1;
        try {
            int firstDate = Integer.parseInt(result[0][0].toString());
            int secondDate = Integer.parseInt(result[0][1].toString());
            weekDiff = firstDate - secondDate;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return weekDiff;
    }
}

