/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.snapshot;

import java.util.List;
import ordermate.database.misc.DayPart;
import ordermate.database.searchers.reports.dailysummary.DailyDebtorSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyNumPatronsByAccountSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyProductivitySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyReconciliationSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySalesSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportByAccountType;
import ordermate.database.searchers.reports.dailysummary.DailyVoucherSummaryReportSearcher;
import ordermate.database.searchers.reports.snapshot.SnapshotReportParameters;

public class SnapshotReportSearcher {
    private final SnapshotReportParameters params;
    private final DailySalesSummaryReportSearcher salesSearcher;
    private final DailyDebtorSummaryReportSearcher debtorSearcher;
    private final DailyProductivitySummaryReportSearcher productivitySearcher;
    private final DailyReconciliationSummaryReportSearcher reconciliationSearcher;
    private final DailyNumPatronsByAccountSearcher numPatronsSearcher;
    private final DailyVoucherSummaryReportSearcher voucherSearcher;

    public SnapshotReportSearcher(List<DayPart> parts) {
        this.params = new SnapshotReportParameters(parts);
        this.salesSearcher = new DailySalesSummaryReportSearcher();
        this.debtorSearcher = new DailyDebtorSummaryReportSearcher();
        this.productivitySearcher = new DailyProductivitySummaryReportSearcher();
        this.reconciliationSearcher = new DailyReconciliationSummaryReportSearcher();
        this.numPatronsSearcher = new DailyNumPatronsByAccountSearcher();
        this.voucherSearcher = new DailyVoucherSummaryReportSearcher();
        this.salesSearcher.setSearchParameters(this.params);
        this.debtorSearcher.setSearchParameters(this.params);
        this.productivitySearcher.setSearchParameters(this.params);
        this.reconciliationSearcher.setSearchParameters(this.params);
        this.numPatronsSearcher.setSearchParameters(this.params);
        this.voucherSearcher.setSearchParameters(this.params);
    }

    public SnapshotReportParameters getParams() {
        this.params.setReportType(new DailySummaryReportByAccountType());
        return this.params;
    }

    public DailySalesSummaryReportSearcher getSalesSearcher() {
        return this.salesSearcher;
    }

    public DailyDebtorSummaryReportSearcher getDebtorSearcher() {
        return this.debtorSearcher;
    }

    public DailyProductivitySummaryReportSearcher getProductivitySearcher() {
        return this.productivitySearcher;
    }

    public DailyReconciliationSummaryReportSearcher getReconciliationSearcher() {
        return this.reconciliationSearcher;
    }

    public DailyNumPatronsByAccountSearcher getPatronsByAccountSearcher() {
        return this.numPatronsSearcher;
    }

    public DailyVoucherSummaryReportSearcher getVoucherSearcher() {
        return this.voucherSearcher;
    }
}

