/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.takings;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Collection;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.takings.CashdrawerTakingsReport;

public class TakingsReportSearcher
extends PropertySearcher<CashdrawerTakingsReport> {
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter<CashDrawer> cashDrawerSearchFilter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final SingleValueSearchFilter<Shift> shiftFilter;
    private boolean onlyActive;

    public TakingsReportSearcher() {
        super(CashdrawerTakingsReport.class);
        this.dateRangeFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE), FinanceTransaction.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.cashDrawerSearchFilter = new MultiOptionSearchFilter<CashDrawer>(FinanceTransaction.Properties.CASH_DRAWER);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(FinanceTransaction.Properties.SALES_LOCATION);
        this.shiftFilter = new ObjectSearchFilter<Shift>(FinanceTransaction.Properties.SHIFT);
        this.onlyActive = false;
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.getCashdrawerFilter());
        this.addSearchFilter(this.getShiftFilter());
        this.getDateRangeFilter().setStart(DateTimeUtils.getOneMonthAgoCal().getTime());
        this.getDateRangeFilter().setEnd(new Date());
    }

    public void onlyActive() {
        this.onlyActive = true;
    }

    public final SingleValueSearchFilter<Shift> getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public final IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Cashdrawer", dataType=CashDrawer.class, plural=FilterConfig.Plural.Multiple, sequence=5)
    public final MultiOptionSearchFilter<CashDrawer> getCashdrawerFilter() {
        return this.cashDrawerSearchFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, sequence=10)
    public final MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(FinanceUnit.Properties.ID, "id").select(FinanceUnit.Properties.ID, "fk_config_finance_unit").select(FinanceTransaction.Properties.CASH_DRAWER, "fk_config_cashdrawer").sum(FinanceTransaction.Properties.PAID, "total").sum(FinanceTransaction.Properties.TIP, "total_tips").linkUsing(FinanceUnit.Properties.ID, FinanceTransaction.Properties.SUB_TYPE).linkUsing(FinanceTransaction.Properties.TRADING_DAY, TradingDay.Properties.ID).linkUsing(FinanceTransaction.Properties.CASH_DRAWER, CashDrawer.Properties.ID);
        if (this.onlyActive) {
            oQuery.active(FinanceTransaction.class);
        } else {
            oQuery.not().equals(FinanceTransaction.Properties.SYSTEM_STATE, "DELETED");
        }
        oQuery.equals(FinanceUnit.Properties.SYSTEM_STATE, "ACTIVE").isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).wherePropertyIn(FinanceUnit.Properties.TYPE, new Object[]{FinanceUnit.CASH_TYPE.toString(), FinanceUnit.CREDIT_TYPE.toString(), FinanceUnit.DEBIT_TYPE.toString(), FinanceUnit.WEB_TYPE.toString()}).groupBy(CashDrawer.Properties.ID).groupBy(FinanceUnit.Properties.TYPE).groupBy(FinanceUnit.Properties.LABEL).orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL).orderBy(CashDrawer.Properties.ID);
        return oQuery;
    }

    public void setStartDate(Date startDate) {
        this.getDateRangeFilter().setStart(startDate);
    }

    public void setEndDate(Date endDate) {
        this.getDateRangeFilter().setEnd(endDate);
    }

    public void setCashDrawers(Collection listOfCashDrawers) {
        this.getCashdrawerFilter().setSearchValue(listOfCashDrawers);
    }
}

