/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.timesheet;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SystemStateSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ordermate.database.departments.Department;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;

public class FinanceTimesheetSearcher
extends PropertySearcher<FinanceTimesheet> {
    private RangeJoinSearchFilter<Date> tradingDayDateFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionSearchFilter userFilter;
    private MultiOptionSearchFilter departmentFilter;
    private Comparator<FinanceTimesheet> comparator;
    private SystemStateSearchFilter systemStateSearchFilter;

    public FinanceTimesheetSearcher() {
        super(FinanceTimesheet.class);
        this.tradingDayDateFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP), FinanceTimesheet.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateFilter);
        this.userFilter = new MultiOptionSearchFilter<User>(FinanceTimesheet.Properties.USER);
        this.departmentFilter = new MultiOptionSearchFilter<Department>(FinanceTimesheet.Properties.DEPARTMENT);
        this.systemStateSearchFilter = new SystemStateSearchFilter(User.class);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.userFilter);
        this.addSearchFilter(this.departmentFilter);
        this.comparator = this.getDefaultComparator();
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(FinanceTimesheet.class);
    }

    @Override
    public List<FinanceTimesheet> search() {
        List<FinanceTimesheet> results = super.search();
        Collections.sort(results, this.comparator);
        return results;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        return super.getObjectQuery();
    }

    public Comparator<FinanceTimesheet> getDefaultComparator() {
        ArrayList comps = new ArrayList();
        List<PropertiedObject.Property<? extends PropertiedObject>> props = Collections.singletonList(FinanceTimesheet.Properties.USER);
        comps.add(new PropertyComparator(props, (PropertiedObject.Property<? extends Comparable>)User.Properties.PAYROLL_ID));
        comps.add(new PropertyComparator(props, User.Properties.NAME));
        comps.add(new PropertyComparator(FinanceTimesheet.Properties.REPORTING_TIME_IN));
        return new SequentialComparator<FinanceTimesheet>(comps);
    }

    public void setComparator(Comparator<FinanceTimesheet> comparator) {
        this.comparator = comparator;
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=3)
    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    @FilterConfig(name="Department", dataType=Department.class, plural=FilterConfig.Plural.Multiple, priority=true, sequence=2)
    public MultiOptionSearchFilter getDepartmentFilter() {
        return this.departmentFilter;
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateFilter() {
        return this.tradingDayDateFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    public SystemStateSearchFilter getSystemStateSearchFilter() {
        return this.systemStateSearchFilter;
    }
}

