/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.vouchers;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.PrefixTextSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.sales.Customer;

public class VoucherSearcher
extends PropertySearcher<GiftVoucher> {
    private ISingleValueSearchFilter uuidPrefixFilter;
    private ISingleValueSearchFilter firstNameFilter;
    private ISingleValueSearchFilter lastNameFilter;
    private IRangedQuerySearchFilter<Date> creationDateRangeFilter;
    private IRangedQuerySearchFilter<Date> activationDateRangeFilter;
    private boolean hideZeroDollarVouchers;

    public VoucherSearcher() {
        super(GiftVoucher.class);
        this.uuidPrefixFilter = new PrefixTextSearchFilter(GiftVoucher.Properties.UNIQUE_ID);
        this.firstNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{GiftVoucher.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.FIRST_NAME));
        this.lastNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{GiftVoucher.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.LAST_NAME));
        this.creationDateRangeFilter = new RangeQuerySearchFilter<Date>(GiftVoucher.Properties.CREATION_DATE);
        this.activationDateRangeFilter = new RangeQuerySearchFilter<Date>(GiftVoucher.Properties.ACTIVATION_DATE);
        this.hideZeroDollarVouchers = true;
        this.addSearchFilter(this.uuidPrefixFilter);
        this.addSearchFilter(this.firstNameFilter);
        this.addSearchFilter(this.lastNameFilter);
        this.addSearchFilter(this.creationDateRangeFilter);
        this.addSearchFilter(this.activationDateRangeFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(this.getPersistentClass()).orderBy(GiftVoucher.Properties.CUSTOMER).orderBy(GiftVoucher.Properties.ACTIVATION_DATE).orderBy(GiftVoucher.Properties.ACTIVATION_TIME).active(GiftVoucher.class);
        if (this.hideZeroDollarVouchers) {
            query = query.not().equals(GiftVoucher.Properties.CACHED_VALUE, 0.0);
        }
        return query;
    }

    @FilterConfig(name="Code", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=4)
    public ISingleValueSearchFilter getUuidPrefixFilter() {
        return this.uuidPrefixFilter;
    }

    @FilterConfig(name="First Name", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public ISingleValueSearchFilter getFirstNameFilter() {
        return this.firstNameFilter;
    }

    @FilterConfig(name="Last Name", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public ISingleValueSearchFilter getLastNameFilter() {
        return this.lastNameFilter;
    }

    public IRangedQuerySearchFilter<Date> getActivationDateRangeFilter() {
        return this.activationDateRangeFilter;
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, nullAllowed=false, dateType=SQLDateType.TIMESTAMP, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getCreationDateRangeFilter() {
        return this.creationDateRangeFilter;
    }

    public void setHideZeroDollarVouchers(boolean value) {
        this.hideZeroDollarVouchers = value;
    }
}

