/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.vouchers;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Customer;

public class VoucherTransactionSearcher
extends PropertySearcher<GiftVoucherTransaction> {
    private ISingleValueSearchFilter<GiftVoucher> voucherFilter;
    private ISingleValueSearchFilter uuidPrefixFilter;
    private ISingleValueSearchFilter firstNameFilter;
    private ISingleValueSearchFilter lastNameFilter;
    private IRangedQuerySearchFilter<Date> createdDayRangeFilter;
    private ObjectSearchFilter<TradingDay> tradingDayFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private Boolean hideZeroDollar;
    private PropertiedObject.Property groupByProperty;

    public VoucherTransactionSearcher() {
        super(GiftVoucherTransaction.class);
        this.voucherFilter = new ObjectSearchFilter<GiftVoucher>(GiftVoucherTransaction.Properties.GIFT_VOUCHER);
        this.uuidPrefixFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{GiftVoucherTransaction.Properties.GIFT_VOUCHER}, new TextSearchFilter(GiftVoucher.Properties.UNIQUE_ID));
        this.firstNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{GiftVoucherTransaction.Properties.GIFT_VOUCHER, GiftVoucher.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.FIRST_NAME));
        this.lastNameFilter = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{GiftVoucherTransaction.Properties.GIFT_VOUCHER, GiftVoucher.Properties.CUSTOMER}, new TextSearchFilter(Customer.Properties.LAST_NAME));
        this.createdDayRangeFilter = new RangeQuerySearchFilter<Date>(GiftVoucherTransaction.Properties.CREATION_DATE, SQLDateType.DATE);
        this.tradingDayFilter = new ObjectSearchFilter<TradingDay>(GiftVoucherTransaction.Properties.TRADING_DAY);
        this.tradingDayDateRangeFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE), GiftVoucherTransaction.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateRangeFilter);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(GiftVoucherTransaction.Properties.SALES_LOCATION);
        this.hideZeroDollar = null;
        this.addSearchFilter(this.voucherFilter);
        this.addSearchFilter(this.uuidPrefixFilter);
        this.addSearchFilter(this.firstNameFilter);
        this.addSearchFilter(this.lastNameFilter);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.createdDayRangeFilter);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(this.getPersistentClass()).orderBy(GiftVoucherTransaction.Properties.CREATION_DATE, false).orderBy(GiftVoucherTransaction.Properties.CREATION_TIME, false).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).active(GiftVoucherTransaction.class);
        if (this.hideZeroDollar != null) {
            query.linkUsing(GiftVoucherTransaction.Properties.GIFT_VOUCHER);
            if (this.hideZeroDollar.booleanValue()) {
                query.not();
            }
            query.equals(GiftVoucher.Properties.CACHED_VALUE, 0.0);
        }
        if (this.groupByProperty != null) {
            return query.groupBy(this.groupByProperty);
        }
        return query;
    }

    public ISingleValueSearchFilter<GiftVoucher> getVoucherFilter() {
        return this.voucherFilter;
    }

    public void setHideZeroDollarFilter(Boolean value) {
        this.hideZeroDollar = value;
    }

    @FilterConfig(name="Code", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=4)
    public ISingleValueSearchFilter getUuidPrefixFilter() {
        return this.uuidPrefixFilter;
    }

    @FilterConfig(name="First Name", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public ISingleValueSearchFilter getFirstNameFilter() {
        return this.firstNameFilter;
    }

    @FilterConfig(name="Last Name", dataType=String.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public ISingleValueSearchFilter getLastNameFilter() {
        return this.lastNameFilter;
    }

    public ObjectSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    public IRangedQuerySearchFilter<Date> getCreatedDayRangeFilter() {
        return this.createdDayRangeFilter;
    }

    public PropertiedObject.Property getGroupByProperty() {
        return this.groupByProperty;
    }

    public void setGroupByProperty(PropertiedObject.Property groupByProperty) {
        this.groupByProperty = groupByProperty;
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, nullAllowed=false, dateType=SQLDateType.TIMESTAMP, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateRangeFilter;
    }

    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, nullAllowed=true, plural=FilterConfig.Plural.Multiple, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

