/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.weekdaysales;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;

public class DayOfWeekSummary
implements PropertiedObject {
    public static final Props Properties = new Props();
    private Price totalSales = Price.ZERO_DOLLAR;
    private int noDaysForSales;
    private Price averageSales = Price.ZERO_DOLLAR;

    public Price getTotalSales() {
        return this.totalSales;
    }

    public void setTotalSales(Price totalSales) {
        this.totalSales = totalSales;
    }

    public void incrementNoDaysForSales() {
        ++this.noDaysForSales;
    }

    public Price getAverageSales() {
        if (this.noDaysForSales != 0) {
            return this.totalSales.divide(this.noDaysForSales);
        }
        return this.totalSales;
    }

    public void addToSales(Price sales) {
        this.totalSales = this.totalSales.add(sales);
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public int getNoDaysForSales() {
        return this.noDaysForSales;
    }

    public void setNoDaysForSales(int noDaysForSales) {
        this.noDaysForSales = noDaysForSales;
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Price> TOTAL_SALES;
        public PropertiedObject.Property<Price> AVERAGE_SALES;
        public PropertiedObject.Property<Integer> NO_DAYS_FOR_SALES;
    }
}

