/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.weekdaysales;

import javax.swing.table.AbstractTableModel;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportCompiler;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportSummary;

public class WeekdaySalesByHourCompilerTableModel
extends AbstractTableModel {
    private WeekdaySalesByHourReportCompiler compiler;
    private static final int COLUMN_COUNT = 8;
    private static final int HOUR_OF_DAY_COL_IDX = 0;
    private static final int MONDAY_SALES_COL_IDX = 1;
    private static final int TUESDAY_SALES_COL_IDX = 2;
    private static final int WEDNESDAY_SALES_COL_IDX = 3;
    private static final int THURSDAY_SALES_COL_IDX = 4;
    private static final int FRIDAY_SALES_COL_IDX = 5;
    private static final int SATURDAY_SALES_COL_IDX = 6;
    private static final int SUNDAY_SALES_COL_IDX = 7;
    public static final String HOUR_OF_DAY_COL_NAME = "Hour Of Day";
    public static final String MONDAY_SALES_COL_NAME = "Monday";
    public static final String TUESDAY_SALES_COL_NAME = "Tuesday";
    public static final String WEDNESDAY_SALES_COL_NAME = "Wednesday";
    public static final String THURSDAY_SALES_COL_NAME = "Thursday";
    public static final String FRIDAY_SALES_COL_NAME = "Friday";
    public static final String SATURDAY_SALES_COL_NAME = "Saturday";
    public static final String SUNDAY_SALES_COL_NAME = "Sunday";

    public WeekdaySalesByHourCompilerTableModel(WeekdaySalesByHourReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public int getRowCount() {
        return this.compiler.getResults().size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) throws IllegalArgumentException {
        if (columnIndex < 0 || columnIndex > 8) {
            throw new IllegalArgumentException("columnIndex is not valid");
        }
        if (rowIndex < 0 || rowIndex > this.compiler.getResults().size()) {
            throw new IllegalArgumentException("rowIndex is not valid");
        }
        WeekdaySalesByHourReportSummary summary = this.compiler.getResults().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                Integer startHour = summary.getHourOfDay();
                Integer endHour = startHour + 1;
                return String.format("%02d", startHour) + ":00 - " + String.format("%02d", endHour) + ":00";
            }
            case 1: {
                return summary.getMondaySummary().getAverageSales();
            }
            case 2: {
                return summary.getTuesdaySummary().getAverageSales();
            }
            case 3: {
                return summary.getWednesdaySummary().getAverageSales();
            }
            case 4: {
                return summary.getThursdaySummary().getAverageSales();
            }
            case 5: {
                return summary.getFridaySummary().getAverageSales();
            }
            case 6: {
                return summary.getSaturdaySummary().getAverageSales();
            }
            case 7: {
                return summary.getSundaySummary().getAverageSales();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        if (column < 0 || column > 8) {
            throw new IllegalArgumentException("column is not valid, must be in range of 0 to " + column);
        }
        switch (column) {
            case 0: {
                return HOUR_OF_DAY_COL_NAME;
            }
            case 1: {
                return MONDAY_SALES_COL_NAME;
            }
            case 2: {
                return TUESDAY_SALES_COL_NAME;
            }
            case 3: {
                return WEDNESDAY_SALES_COL_NAME;
            }
            case 4: {
                return THURSDAY_SALES_COL_NAME;
            }
            case 5: {
                return FRIDAY_SALES_COL_NAME;
            }
            case 6: {
                return SATURDAY_SALES_COL_NAME;
            }
            case 7: {
                return SUNDAY_SALES_COL_NAME;
            }
        }
        return "";
    }
}

