/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.weekdaysales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.weekdaysales.WeekdaySalesByHourReport;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportSearcher;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportSummary;

public class WeekdaySalesByHourReportCompiler {
    private WeekdaySalesByHourReportSearcher searcher;
    private List<WeekdaySalesByHourReportSummary> cachedResults;
    private Set<TradingDay> cachedDays;
    private boolean isManualChangeOfDay = SystemProperty.getInstance().isManualChangeOfDay();

    public WeekdaySalesByHourReportCompiler(WeekdaySalesByHourReportSearcher searcher) {
        this.searcher = searcher;
        this.cachedResults = new ArrayList<WeekdaySalesByHourReportSummary>();
    }

    public List<WeekdaySalesByHourReportSummary> compileResults() {
        this.cachedResults.clear();
        this.prepareTradingDayData();
        Map<Integer, WeekdaySalesByHourReportSummary> compiledResultsMap = this.createEmptyDatasetMap();
        HashMap<Integer, Set<Date>> dateMap = new HashMap<Integer, Set<Date>>();
        for (WeekdaySalesByHourReport weekdaySales : this.searcher.search()) {
            Calendar saleDate = DateTimeUtils.getCalendar(weekdaySales.getCreationDate());
            this.cleanTimeOnKeepHour(saleDate);
            int dayOfWeek = this.getDayOfWeek(saleDate.getTime());
            int hourOfWeek = saleDate.get(11);
            WeekdaySalesByHourReportSummary salesSummary = compiledResultsMap.get(hourOfWeek);
            if (this.isNewDateForDayOfWeek(dayOfWeek, saleDate.getTime(), dateMap)) {
                salesSummary.getSummaryForDay(dayOfWeek).incrementNoDaysForSales();
            }
            salesSummary.getSummaryForDay(dayOfWeek).addToSales(weekdaySales.getUnitPrice().multiply(weekdaySales.getQuantity()));
        }
        this.cachedResults.clear();
        if (Boolean.TRUE.equals(this.searcher.getHideZeroFilter().getSearchValue())) {
            this.cachedResults.addAll(this.getFilteredResults(compiledResultsMap.values()));
        } else {
            this.cachedResults.addAll(compiledResultsMap.values());
        }
        Collections.sort(this.cachedResults);
        if (!this.isManualChangeOfDay) {
            this.adjustOrderForTradingDayRollover();
        } else {
            this.adjustOrderForEarliestOpenTime();
        }
        return this.cachedResults;
    }

    public List<WeekdaySalesByHourReportSummary> getFilteredResults(Collection<WeekdaySalesByHourReportSummary> unfilteredResults) {
        ArrayList<WeekdaySalesByHourReportSummary> filteredResults = new ArrayList<WeekdaySalesByHourReportSummary>();
        for (WeekdaySalesByHourReportSummary summary : unfilteredResults) {
            if (!summary.periodHasFigures()) continue;
            filteredResults.add(summary);
        }
        return filteredResults;
    }

    private boolean isNewDateForDayOfWeek(int dayOfWeek, Date saleDate, Map<Integer, Set<Date>> dateMap) {
        if (!dateMap.containsKey(dayOfWeek)) {
            HashSet<Date> dateSet = new HashSet<Date>();
            dateSet.add(saleDate);
            dateMap.put(dayOfWeek, dateSet);
            return true;
        }
        Set<Date> dateSet = dateMap.get(dayOfWeek);
        if (!dateSet.contains(saleDate)) {
            dateSet.add(saleDate);
            return true;
        }
        return false;
    }

    private void cleanTimeOnKeepHour(Calendar calToClean) {
        calToClean.set(14, 0);
        calToClean.set(13, 0);
        calToClean.set(12, 0);
    }

    public Map<Integer, WeekdaySalesByHourReportSummary> createEmptyDatasetMap() {
        HashMap<Integer, WeekdaySalesByHourReportSummary> resultsMap = new HashMap<Integer, WeekdaySalesByHourReportSummary>();
        for (int i = 0; i < 24; ++i) {
            resultsMap.put(i, new WeekdaySalesByHourReportSummary(i));
        }
        return resultsMap;
    }

    public WeekdaySalesByHourReportSearcher getSearcher() {
        return this.searcher;
    }

    public List<WeekdaySalesByHourReportSummary> getResults() {
        return this.cachedResults;
    }

    public List<String> getColumnNames() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("Hour Of Day");
        newList.add("Monday");
        newList.add("Tuesday");
        newList.add("Wednesday");
        newList.add("Thursday");
        newList.add("Friday");
        newList.add("Saturday");
        newList.add("Sunday");
        return newList;
    }

    public boolean isManualChangeOfDay() {
        return this.isManualChangeOfDay;
    }

    public void setFilterPeriodsWithNoSalesData(boolean filterPeriods) {
        this.searcher.getHideZeroFilter().setSearchValue(filterPeriods);
    }

    private void prepareTradingDayData() {
        this.isManualChangeOfDay = SystemProperty.getInstance().isManualChangeOfDay();
        this.fillTradingDayCache((Date)this.searcher.getDateRangeFilter().getStart(), (Date)this.searcher.getDateRangeFilter().getEnd());
    }

    private void fillTradingDayCache(Date start, Date end) {
        if (this.cachedDays == null) {
            this.cachedDays = new HashSet<TradingDay>();
        } else if (!this.cachedDays.isEmpty()) {
            this.cachedDays.clear();
        }
        String startDate = DateTimeUtils.getSQLTimestampFormat().format(start);
        String endDate = DateTimeUtils.getSQLTimestampFormat().format(end);
        this.cachedDays.addAll(PersistenceManager.getObjectList(TradingDay.class, new ObjectQuery().select(TradingDay.class).whereFunction("TIMESTAMP(" + TradingDay.Properties.DATE + ", " + TradingDay.Properties.TIME + ") BETWEEN '" + startDate + "' AND '" + endDate + "'").toString()));
    }

    private int getDayOfWeek(Date date) {
        TradingDay day = this.getTradingDayForDate(date);
        int dayOfWeek = 0;
        dayOfWeek = day == null ? DateTimeUtils.getDayOfWeek(date).intValue() : TradingDay.getDayOfWeekForTradingDay(day).intValue();
        return dayOfWeek;
    }

    private TradingDay getTradingDayForDate(Date date) {
        if (date == null || this.cachedDays == null) {
            return null;
        }
        for (TradingDay day : this.cachedDays) {
            if (!(day.isOpen() ? date.after(day.getOpenDateTime()) : date.after(day.getOpenDateTime()) && date.before(day.getCloseDateTime()))) continue;
            return day;
        }
        return null;
    }

    private void performReorder(int firstHourOfDay) {
        ArrayList<WeekdaySalesByHourReportSummary> toMove = new ArrayList<WeekdaySalesByHourReportSummary>();
        for (WeekdaySalesByHourReportSummary report : this.cachedResults) {
            if (firstHourOfDay > report.getHourOfDay()) {
                toMove.add(report);
            }
            report.getHourOfDay();
        }
        this.cachedResults.removeAll(toMove);
        this.cachedResults.addAll(toMove);
    }

    private void adjustOrderForTradingDayRollover() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(SystemProperty.getInstance().getChangeDayTime());
        this.performReorder(cal.get(11));
    }

    private void adjustOrderForEarliestOpenTime() {
        TradingDay earliest = null;
        for (TradingDay day : this.cachedDays) {
            if (earliest == null) {
                earliest = day;
                continue;
            }
            if (!earliest.getTime().after(day.getTime())) continue;
            earliest = day;
        }
        if (earliest == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(earliest.getTime());
        this.performReorder(cal.get(11));
    }
}

