/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.weekdaysales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.weekdaysales.WeekdaySalesByHourReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;

public class WeekdaySalesByHourReportSearcher
extends PropertySearcher<WeekdaySalesByHourReport> {
    private final DateRangeSearchFilter dateFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final ISingleValueSearchFilter<String> hideZeroFilter;

    public WeekdaySalesByHourReportSearcher() {
        super(WeekdaySalesByHourReport.class);
        this.dateFilter = new OptimisedDateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateFilter);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.hideZeroFilter = new BooleanSearchFilter(null);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.salesLocationFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(SalesLineItem.Properties.ID).sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesItemQuantity.Properties.CREATION_TIME).select(SalesComponent.Properties.SAVED_UNIT_PRICE).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesLineItem.Properties.ID).linkUsing(SalesLineItem.Properties.ACCOUNT).linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID).groupBy(SalesComponent.Properties.ID).orderBy(SalesLineItem.Properties.ID);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateFilter;
    }

    @FilterConfig(name="Hide Zero Sales", dataType=Boolean.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public ISingleValueSearchFilter getHideZeroFilter() {
        return this.hideZeroFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

