/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.reports.weekdaysales;

import au.com.ordermate.persistence.PropertiedObject;
import ordermate.database.searchers.reports.weekdaysales.DayOfWeekSummary;

public class WeekdaySalesByHourReportSummary
implements PropertiedObject,
Comparable<WeekdaySalesByHourReportSummary> {
    public static final Props Properties = new Props();
    private int hourOfDay;
    private DayOfWeekSummary sundaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary mondaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary tuesdaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary wednesdaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary thursdaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary fridaySummary = new DayOfWeekSummary();
    private DayOfWeekSummary saturdaySummary = new DayOfWeekSummary();

    public WeekdaySalesByHourReportSummary(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    @Override
    public int compareTo(WeekdaySalesByHourReportSummary o) {
        return Integer.valueOf(this.hourOfDay).compareTo(o.getHourOfDay());
    }

    public int getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(int hourOfDay) {
        this.hourOfDay = hourOfDay;
    }

    public void incrementOccuranceOfDay(int dayOfWeek) {
        this.getSummaryForDay(dayOfWeek).incrementNoDaysForSales();
    }

    public DayOfWeekSummary getSummaryForDay(int dayOfWeek) throws IllegalArgumentException {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("dayOfWeek must be a within the range of 1 - 7");
        }
        switch (dayOfWeek) {
            case 1: {
                return this.mondaySummary;
            }
            case 2: {
                return this.tuesdaySummary;
            }
            case 3: {
                return this.wednesdaySummary;
            }
            case 4: {
                return this.thursdaySummary;
            }
            case 5: {
                return this.fridaySummary;
            }
            case 6: {
                return this.saturdaySummary;
            }
            case 7: {
                return this.sundaySummary;
            }
        }
        return null;
    }

    public DayOfWeekSummary getSundaySummary() {
        return this.sundaySummary;
    }

    public DayOfWeekSummary getMondaySummary() {
        return this.mondaySummary;
    }

    public DayOfWeekSummary getTuesdaySummary() {
        return this.tuesdaySummary;
    }

    public DayOfWeekSummary getWednesdaySummary() {
        return this.wednesdaySummary;
    }

    public DayOfWeekSummary getThursdaySummary() {
        return this.thursdaySummary;
    }

    public DayOfWeekSummary getFridaySummary() {
        return this.fridaySummary;
    }

    public DayOfWeekSummary getSaturdaySummary() {
        return this.saturdaySummary;
    }

    public boolean periodHasFigures() {
        return !this.sundaySummary.getTotalSales().isZero() || !this.mondaySummary.getTotalSales().isZero() || !this.tuesdaySummary.getTotalSales().isZero() || !this.wednesdaySummary.getTotalSales().isZero() || !this.thursdaySummary.getTotalSales().isZero() || !this.fridaySummary.getTotalSales().isZero() || !this.saturdaySummary.getTotalSales().isZero();
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<Integer> HOUR_OF_DAY;
        public PropertiedObject.Property<DayOfWeekSummary> SUNDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> MONDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> TUESDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> WEDNESDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> THURSDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> FRIDAY_SUMMARY;
        public PropertiedObject.Property<DayOfWeekSummary> SATURDAY_SUMMARY;
    }
}

