/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.sales;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;

public class AccountResultsSorter {
    private static final int DEFAULT_LIMIT = 12;
    private static PropValueComparator<Date, Account> financeTransDate = new PropValueComparator<Date, Account>(){

        @Override
        public Date getValueToCompare(Account obj) {
            List<FinanceTransaction> trans = obj.getFinanceTransactions();
            Collections.sort(trans, new PropertyComparator(FinanceTransaction.Properties.CREATION_TIME));
            Collections.reverse(trans);
            return trans.get(0).getCreationTime();
        }
    };
    private static PropValueComparator<Date, Account> saleDebtorDate = new PropValueComparator<Date, Account>(){

        @Override
        public Date getValueToCompare(Account obj) {
            ObjectQuery query = new ObjectQuery();
            query.select(DebtorSale.class).equals(DebtorSale.Properties.SALE_ACCOUNT, obj);
            List<DebtorSale> sales = PersistenceManager.getObjectList(DebtorSale.class, query.toString(), null);
            Collections.sort(sales, new PropertyComparator((PropertiedObject.Property<? extends Comparable>)DebtorSale.Properties.SALE_DATE));
            Collections.reverse(sales);
            return sales.get(0).getSaleDate();
        }
    };

    public static List<Account> combineLists(List<Account> accountSearcherResults, List<Account> accountSearcherWithDebtorPaymentsResults) {
        ArrayList<Account> toReturn = new ArrayList<Account>();
        HashSet<Account> uniqueAccounts = new HashSet<Account>();
        uniqueAccounts.addAll(accountSearcherResults);
        uniqueAccounts.addAll(accountSearcherWithDebtorPaymentsResults);
        toReturn.addAll(uniqueAccounts);
        Collections.sort(toReturn, new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                Date date1 = null;
                date1 = o1.isDebtorSale() ? (Date)saleDebtorDate.getValueToCompare(o1) : (o1.hasPayments() ? (Date)financeTransDate.getValueToCompare(o1) : o1.getCreationDateTime());
                Date date2 = null;
                date2 = o2.isDebtorSale() ? (Date)saleDebtorDate.getValueToCompare(o2) : (o2.hasPayments() ? (Date)financeTransDate.getValueToCompare(o2) : o2.getCreationDateTime());
                return date1.compareTo(date2);
            }
        });
        Collections.reverse(toReturn);
        return toReturn.size() > 12 ? toReturn.subList(0, 12) : toReturn;
    }

    static interface PropValueComparator<K extends Comparable<K>, T extends PropertiedObject> {
        public K getValueToCompare(T var1);
    }
}

