/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.EquivalentObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.AccountOptimisedDateRangeSearchFilter;
import ordermate.database.filters.MultiOptionWithBlankOptionSearchFilter;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.users.User;

public class AccountSearcher
extends DefaultPropertySearcher<Account> {
    private static final int LIMIT_NUM = 100000;
    private ObjectSearchFilter<Long> accountIDSearch;
    private DateRangeSearchFilter dateRangeSearch;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private DateRangeSearchFilter timeRangeSearch;
    private final DateRangeSearchFilter dateDueRangeSearch;
    private final TimeSearchFilter timeDueSearch;
    private final MultiOptionSearchFilter openedByUser;
    private final MultiOptionSearchFilter closedByUser;
    private ObjectSearchFilter<Customer> customerSearch;
    private ObjectSearchFilter<AccountState> accountStateSearch;
    private ObjectSearchFilter<Account.ReceiptPrintState> receiptPrintStateSearch;
    private ObjectSearchFilter<Shift> financeShiftSearch;
    private MultiOptionJoinSearchFilter<String> shiftNameSearch;
    private RangeJoinSearchFilter<Price> financeTranAmountRangeSearch;
    private RangeQuerySearchFilter savedTotalRangeSearch;
    private MultiOptionSearchFilter accountTypeListSearch;
    private MultiOptionSearchFilter paymentTypeSearch;
    private ObjectJoinSearchFilter paymentType;
    private ObjectJoinSearchFilter<List<Terminal>> terminalSearch;
    private ObjectJoinSearchFilter<TradingDay> payOffDaySearch;
    private MultiOptionSearchFilter multiCustomerSearch;
    private ObjectJoinSearchFilter driverSearch;
    private ObjectSearchFilter<TradingDay> tradingDaySearch;
    private EquivalentObjectSearchFilter eftposReferenceSearch;
    private MultiOptionSearchFilter orderSourceTypeListSearch;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private PropertiedObject.Property[] orderByProps;
    private boolean orderAscending;
    private final List<QuerySearchFilter> allSearchProperties;

    protected DateRangeSearchFilter createOptimisedDateRangeSearchFilter() {
        return new AccountOptimisedDateRangeSearchFilter(Account.Properties.DATE_DUE, SQLDateType.DATE);
    }

    public AccountSearcher() {
        this(100000, Account.Properties.CREATION_DATE_TIME, false);
    }

    public AccountSearcher(int limitNum, PropertiedObject.Property orderByProperty, boolean ascending) {
        super(Account.class);
        PropertiedObject.Property[] propertyArray;
        this.accountIDSearch = new ObjectSearchFilter(Account.Properties.ID);
        this.dateRangeSearch = new OptimisedDateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeSearch);
        this.timeRangeSearch = new OptimisedDateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIME);
        this.dateDueRangeSearch = this.createOptimisedDateRangeSearchFilter();
        this.timeDueSearch = new TimeSearchFilter(Account.Properties.TIME_DUE);
        this.openedByUser = new MultiOptionSearchFilter<User>(Account.Properties.OPENING_USER);
        this.closedByUser = new MultiOptionSearchFilter<User>(Account.Properties.CLOSING_USER);
        this.customerSearch = new ObjectSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.accountStateSearch = new ObjectSearchFilter<AccountState>(Account.Properties.ACCOUNT_STATE);
        this.receiptPrintStateSearch = new ObjectSearchFilter<Account.ReceiptPrintState>(Account.Properties.RECEIPT_STATE);
        this.financeShiftSearch = new ObjectSearchFilter<Shift>(Account.Properties.SHIFT);
        this.shiftNameSearch = new MultiOptionJoinSearchFilter(ConfigShift.getAllConfigShiftsNames(), Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.LABEL);
        this.financeTranAmountRangeSearch = new RangeJoinSearchFilter(new PropertiedObject.Property[]{FinanceTransaction.Properties.ACCOUNT}, new RangeQuerySearchFilter(FinanceTransaction.Properties.PAID));
        this.savedTotalRangeSearch = new RangeQuerySearchFilter(Account.Properties.SAVED_TOTAL);
        this.accountTypeListSearch = new MultiOptionSearchFilter<AccountType>(Account.Properties.ACCOUNT_TYPE);
        this.paymentTypeSearch = new MultiOptionSearchFilter<FinanceUnit>(FinanceTransaction.Properties.SUB_TYPE);
        this.paymentType = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS}, this.paymentTypeSearch);
        this.terminalSearch = new ObjectJoinSearchFilter<Terminal>(new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS}, new MultiOptionSearchFilter<Terminal>(FinanceTransaction.Properties.TERMINAL));
        this.payOffDaySearch = new ObjectJoinSearchFilter<TradingDay>(new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS}, new ObjectSearchFilter<TradingDay>(FinanceTransaction.Properties.TRADING_DAY));
        this.multiCustomerSearch = new MultiOptionSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.driverSearch = new ObjectJoinSearchFilter<User>(new PropertiedObject.Property[]{PhoneAccount.Properties.DELIVERY}, new MultiOptionSearchFilter<User>(Delivery.Properties.DRIVER));
        this.tradingDaySearch = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.eftposReferenceSearch = new EquivalentObjectSearchFilter(new PropertiedObject.Property[]{EftposTransaction.Properties.AUTH_CODE, EftposTransaction.Properties.TRANSACTION_REFERENCE}, new ObjectJoinSearchFilter(new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS}, new TextSearchFilter(null)));
        this.orderSourceTypeListSearch = new MultiOptionWithBlankOptionSearchFilter((PropertiedObject.Property)Account.Properties.SOURCE);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(Account.Properties.SALES_LOCATION);
        this.orderByProps = null;
        this.orderAscending = false;
        this.allSearchProperties = Arrays.asList(this.accountIDSearch, this.openedByUser, this.closedByUser, this.tradingDayDateRangeAdapter, this.timeRangeSearch, this.customerSearch, this.accountStateSearch, this.financeShiftSearch, this.shiftNameSearch, this.financeTranAmountRangeSearch, this.savedTotalRangeSearch, this.accountTypeListSearch, this.terminalSearch, this.multiCustomerSearch, this.paymentType, this.tradingDaySearch, this.receiptPrintStateSearch, this.eftposReferenceSearch, this.payOffDaySearch, this.dateDueRangeSearch, this.timeDueSearch, this.driverSearch, this.orderSourceTypeListSearch, this.salesLocationFilter);
        this.setLimit(limitNum);
        this.setSearchFilters(this.allSearchProperties);
        if (orderByProperty != null) {
            PropertiedObject.Property[] propertyArray2 = new PropertiedObject.Property[1];
            propertyArray = propertyArray2;
            propertyArray2[0] = orderByProperty;
        } else {
            propertyArray = null;
        }
        this.orderByProps = propertyArray;
        this.orderAscending = ascending;
    }

    public AccountSearcher(int limitNum, PropertiedObject.Property orderByProperty) {
        this(limitNum, orderByProperty, true);
    }

    public void setAccountID(Long accountID) {
        this.accountIDSearch.setSearchValue(accountID);
    }

    public void setStartDateRange(Date start) {
        this.dateRangeSearch.setStart(start);
    }

    public void setEndDateRange(Date end) {
        this.dateRangeSearch.setEnd(end);
    }

    public boolean hasDateRange() {
        return this.dateRangeSearch.hasSearchValue();
    }

    public void setCustomerSearch(Customer customer) {
        this.customerSearch.setSearchValue(customer);
    }

    public void setAccountOpen(boolean isOpen) {
        AccountState state = isOpen ? AccountState.OPEN : AccountState.CLOSED;
        this.accountStateSearch.setSearchValue(state);
    }

    public void setFinanceShift(Shift shift) {
        this.financeShiftSearch.setSearchValue(shift);
    }

    public void setFinanceShiftName(String name) {
        this.shiftNameSearch.setSearchValue((Object)name);
    }

    public void setFinanceTransactionAmount(Price startAmount, Price endAmount) {
        this.financeTranAmountRangeSearch.setStart((Comparable)startAmount);
        this.financeTranAmountRangeSearch.setEnd((Comparable)endAmount);
    }

    public void setAccountTypes(List<AccountType> accountTypes) {
        ArrayList<String> typeValues = new ArrayList<String>();
        for (AccountType type : accountTypes) {
            typeValues.add(type.getType());
        }
        this.accountTypeListSearch.setSearchValue(typeValues);
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(Account.class).distinct();
        query.linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID);
        PropertiedObject.Property[] propToOrderBy = new PropertiedObject.Property[]{Account.Properties.CREATION_DATE_TIME};
        if (this.orderByProps != null && (propToOrderBy = this.orderByProps).length > 0 && Customer.class.equals(propToOrderBy[0].getOwner())) {
            query.linkUsing(Account.Properties.CUSTOMER);
        }
        for (PropertiedObject.Property orderBy : propToOrderBy) {
            query = query.orderBy(orderBy, !this.orderAscending);
        }
        return query;
    }

    @Override
    public List<Account> search() {
        List<Account> searchResults = super.search();
        for (Account acc : searchResults) {
            if (acc.getCustomer() == null || !acc.getCustomer().hasChanged()) continue;
            acc.updateCustomerReference();
        }
        return searchResults;
    }

    public void setPaymentType(List paymentTypes) {
        this.paymentType.setSearchValue(paymentTypes);
    }

    @FilterConfig(name="Finance Unit", dataType=FinanceUnit.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=9)
    public ObjectJoinSearchFilter getPaymentType() {
        return this.paymentType;
    }

    public ObjectSearchFilter<Shift> getFinanceShiftSearch() {
        return this.financeShiftSearch;
    }

    @FilterConfig(name="Account Type", dataType=AccountType.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=2)
    public MultiOptionSearchFilter getAccountTypeListSearch() {
        return this.accountTypeListSearch;
    }

    @FilterConfig(name="Drivers", plural=FilterConfig.Plural.Multiple, dataType=User.class, where="active = 1 AND hidden = 0 AND is_driver = 1", order="Surname, Firstname", priority=false, sequence=8)
    public ISingleValueSearchFilter getDeliveryDriverSearch() {
        return this.driverSearch;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public RangeQuerySearchFilter getDateRangeSearch() {
        return this.dateRangeSearch;
    }

    @FilterConfig(name="Time", dateType=SQLDateType.TIME, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public RangeQuerySearchFilter<Date> getTimeRangeSearch() {
        return this.timeRangeSearch;
    }

    @FilterConfig(name="Receipt #", dataType=String.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=5)
    public ObjectSearchFilter getIDSearch() {
        return this.accountIDSearch;
    }

    @FilterConfig(name="Customer", dataType=Customer.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, makerName="Customer Details")
    public ObjectSearchFilter getCustomerSearch() {
        return this.customerSearch;
    }

    public ObjectSearchFilter getAccountStateSearch() {
        return this.accountStateSearch;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=14)
    public MultiOptionJoinSearchFilter<String> getShiftNameSearch() {
        return this.shiftNameSearch;
    }

    public RangeJoinSearchFilter getFinanceTransactionAmountRangeSearch() {
        return this.financeTranAmountRangeSearch;
    }

    public MultiOptionSearchFilter getPaymentTypeSearch() {
        return this.paymentTypeSearch;
    }

    public MultiOptionSearchFilter getMultiCustomerSearch() {
        return this.multiCustomerSearch;
    }

    @FilterConfig(name="$Total", dataType=Integer.class, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=4)
    public RangeQuerySearchFilter getSavedTotalSearch() {
        return this.savedTotalRangeSearch;
    }

    @FilterConfig(name="Terminals", dataType=Terminal.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=10)
    public ObjectJoinSearchFilter<List<Terminal>> getTerminalSearch() {
        return this.terminalSearch;
    }

    public DateRangeSearchFilter getDateDueRangeSearch() {
        return this.dateDueRangeSearch;
    }

    public TimeSearchFilter getTimeDueSearch() {
        return this.timeDueSearch;
    }

    public void setTradingDay(TradingDay tradingDay) {
        this.tradingDaySearch.setSearchValue(tradingDay);
    }

    public void setReceiptPrintState(Account.ReceiptPrintState printState) {
        this.receiptPrintStateSearch.setSearchValue(printState);
    }

    @FilterConfig(name="Printed", dataType=Account.ReceiptPrintState.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=false, sequence=12)
    public ObjectSearchFilter getReceiptPrintStateSearch() {
        return this.receiptPrintStateSearch;
    }

    public void setAuthCode(String authCode) {
        this.eftposReferenceSearch.setObject(authCode);
    }

    public SingleValueQuerySearchFilter<TradingDay> getPayOffDayFilter() {
        return this.payOffDaySearch;
    }

    public PropertiedObject.Property[] getOrderByProps() {
        return this.orderByProps;
    }

    public void setOrderByProps(PropertiedObject.Property ... orderByProp) {
        this.orderByProps = orderByProp;
    }

    public void disableOptimisation() {
        this.dateRangeSearch = new DateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeSearch);
    }

    public void setOrderAscending(boolean value) {
        this.orderAscending = value;
    }

    @FilterConfig(name="Order Source", dataType=String.class, select="SELECT DISTINCT source FROM sales_account", order="source", plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=11)
    public MultiOptionSearchFilter getOrderSourceListSearch() {
        return this.orderSourceTypeListSearch;
    }

    @FilterConfig(name="Opened User", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=7)
    public MultiOptionSearchFilter getOpenedByUser() {
        return this.openedByUser;
    }

    @FilterConfig(name="Closed User", dataType=User.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=8)
    public MultiOptionSearchFilter getClosedByUser() {
        return this.closedByUser;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=10)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }
}

