/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.QuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.EquivalentObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.abstracts.AbstractSinglePropertySearchFilter;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;

public class AccountSearcherWithDebtorPayments
extends DefaultPropertySearcher<Account> {
    private static final int LIMIT_NUM = 3000;
    private ObjectSearchFilter accountIDSearch;
    private DateRangeSearchFilter dateRangeSearch;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private DateRangeSearchFilter timeRangeSearch;
    private ObjectSearchFilter customerSearch;
    private ObjectSearchFilter accountStateSearch;
    private ObjectSearchFilter receiptPrintStateSearch;
    private ObjectSearchFilter financeShiftSearch;
    private ObjectJoinSearchFilter shiftNameSearch;
    private RangeJoinSearchFilter financeTranAmountRangeSearch;
    private RangeQuerySearchFilter savedTotalRangeSearch;
    private MultiOptionSearchFilter accountTypeListSearch;
    private ObjectJoinSearchFilter<List<Terminal>> terminalSearch;
    private RangeJoinSearchFilter payOffDaySearch;
    private MultiOptionSearchFilter multiCustomerSearch;
    private ObjectJoinSearchFilter driverSearch;
    private ObjectSearchFilter tradingDaySearch;
    private EquivalentObjectSearchFilter eftposReferenceSearch;
    private PropertiedObject.Property orderByProp;
    private boolean orderAscending;
    private final List<QuerySearchFilter> allSearchProperties;

    public AccountSearcherWithDebtorPayments() {
        this(3000, Account.Properties.CREATION_DATE_TIME, false);
    }

    public AccountSearcherWithDebtorPayments(int limitNum, PropertiedObject.Property orderByProperty, boolean ascending) {
        super(Account.class);
        this.accountIDSearch = new ObjectSearchFilter(Account.Properties.ID);
        this.dateRangeSearch = new DateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeSearch);
        this.timeRangeSearch = new DateRangeSearchFilter(Account.Properties.CREATION_DATE_TIME, SQLDateType.TIME);
        this.customerSearch = new ObjectSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.accountStateSearch = new ObjectSearchFilter<AccountState>(Account.Properties.ACCOUNT_STATE);
        this.receiptPrintStateSearch = new ObjectSearchFilter<Account.ReceiptPrintState>(Account.Properties.RECEIPT_STATE);
        this.financeShiftSearch = new ObjectSearchFilter<Shift>(Account.Properties.SHIFT);
        this.shiftNameSearch = new ObjectJoinSearchFilter<String>(new PropertiedObject.Property[]{Account.Properties.SHIFT}, new ObjectSearchFilter<String>(Shift.Properties.NAME));
        this.financeTranAmountRangeSearch = new RangeJoinSearchFilter(new PropertiedObject.Property[]{DebtorSale.Properties.SALE_ACCOUNT}, new RangeQuerySearchFilter(DebtorSale.Properties.TOTAL));
        this.savedTotalRangeSearch = new RangeQuerySearchFilter(Account.Properties.SAVED_TOTAL);
        this.accountTypeListSearch = new MultiOptionSearchFilter<AccountType>(Account.Properties.ACCOUNT_TYPE);
        this.terminalSearch = new ObjectJoinSearchFilter<Terminal>(new PropertiedObject.Property[]{Account.Properties.DEBTOR_SALE}, new MultiOptionSearchFilter<Terminal>(DebtorSale.Properties.TERMINAL));
        this.payOffDaySearch = new RangeJoinSearchFilter<Date>(new PropertiedObject.Property[]{DebtorSale.Properties.SALE_ACCOUNT}, new DateRangeSearchFilter(DebtorSale.Properties.SALE_DATE, SQLDateType.TIMESTAMP));
        this.multiCustomerSearch = new MultiOptionSearchFilter<Customer>(Account.Properties.CUSTOMER);
        this.driverSearch = new ObjectJoinSearchFilter<User>(new PropertiedObject.Property[]{PhoneAccount.Properties.DELIVERY}, new MultiOptionSearchFilter<User>(Delivery.Properties.DRIVER));
        this.tradingDaySearch = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.eftposReferenceSearch = new EquivalentObjectSearchFilter(new PropertiedObject.Property[]{EftposTransaction.Properties.AUTH_CODE, EftposTransaction.Properties.TRANSACTION_REFERENCE}, new ObjectJoinSearchFilter(new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS}, new TextSearchFilter(null)));
        this.orderByProp = null;
        this.orderAscending = false;
        this.allSearchProperties = Arrays.asList(this.accountIDSearch, this.tradingDayDateRangeAdapter, this.timeRangeSearch, this.customerSearch, this.accountStateSearch, this.financeShiftSearch, this.shiftNameSearch, this.financeTranAmountRangeSearch, this.savedTotalRangeSearch, this.accountTypeListSearch, this.terminalSearch, this.multiCustomerSearch, this.tradingDaySearch, this.receiptPrintStateSearch, this.eftposReferenceSearch, this.payOffDaySearch);
        this.setLimit(limitNum);
        this.setSearchFilters(this.allSearchProperties);
        this.orderByProp = orderByProperty;
        this.orderAscending = ascending;
    }

    public AccountSearcherWithDebtorPayments(int limitNum, PropertiedObject.Property orderByProperty) {
        this(limitNum, orderByProperty, true);
    }

    public void setAccountID(Long accountID) {
        this.accountIDSearch.setSearchValue(accountID);
    }

    public void setStartDateRange(Date start) {
        this.dateRangeSearch.setStart(start);
    }

    public void setEndDateRange(Date end) {
        this.dateRangeSearch.setEnd(end);
    }

    public boolean hasDateRange() {
        return this.dateRangeSearch.hasSearchValue();
    }

    public void setCustomerSearch(Customer customer) {
        this.customerSearch.setSearchValue(customer);
    }

    public void setAccountOpen(boolean isOpen) {
        String state = isOpen ? "OPEN" : "CLOSED";
        this.accountStateSearch.setSearchValue(state);
    }

    public void setFinanceShift(Shift shift) {
        this.financeShiftSearch.setSearchValue(shift);
    }

    public void setFinanceShiftName(String name) {
        this.shiftNameSearch.setSearchValue(name);
    }

    public void setFinanceTransactionAmount(Price startAmount, Price endAmount) {
        this.financeTranAmountRangeSearch.setStart(startAmount);
        this.financeTranAmountRangeSearch.setEnd(endAmount);
    }

    public void setAccountTypes(List<AccountType> accountTypes) {
        ArrayList<String> typeValues = new ArrayList<String>();
        for (AccountType type : accountTypes) {
            typeValues.add(type.getType());
        }
        this.accountTypeListSearch.setSearchValue(typeValues);
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(Account.class).distinct();
        query.linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID);
        PropertiedObject.Property propToOrderBy = Account.Properties.CREATION_DATE_TIME;
        if (this.orderByProp != null) {
            propToOrderBy = this.orderByProp;
        }
        query = this.orderAscending ? query.orderBy(propToOrderBy) : query.orderByDesc(propToOrderBy);
        return query;
    }

    public AbstractSinglePropertySearchFilter getFinanceShiftSearch() {
        return this.financeShiftSearch;
    }

    public MultiOptionSearchFilter getAccountTypeListSearch() {
        return this.accountTypeListSearch;
    }

    public ISingleValueSearchFilter getDeliveryDriverSearch() {
        return this.driverSearch;
    }

    public RangeQuerySearchFilter getDateRangeSearch() {
        return this.dateRangeSearch;
    }

    public RangeQuerySearchFilter<Date> getTimeRangeSearch() {
        return this.timeRangeSearch;
    }

    public ObjectSearchFilter getIDSearch() {
        return this.accountIDSearch;
    }

    public ObjectSearchFilter getCustomerSearch() {
        return this.customerSearch;
    }

    public AbstractSinglePropertySearchFilter getAccountStateSearch() {
        return this.accountStateSearch;
    }

    public ObjectJoinSearchFilter getShiftNameSearch() {
        return this.shiftNameSearch;
    }

    public RangeJoinSearchFilter getFinanceTransactionAmountRangeSearch() {
        return this.financeTranAmountRangeSearch;
    }

    public MultiOptionSearchFilter getMultiCustomerSearch() {
        return this.multiCustomerSearch;
    }

    public RangeQuerySearchFilter getSavedTotalSearch() {
        return this.savedTotalRangeSearch;
    }

    public ObjectJoinSearchFilter<List<Terminal>> getTerminalSearch() {
        return this.terminalSearch;
    }

    public void setTradingDay(TradingDay tradingDay) {
        this.tradingDaySearch.setSearchValue(tradingDay);
    }

    public void setReceiptPrintState(Account.ReceiptPrintState printState) {
        this.receiptPrintStateSearch.setSearchValue(printState);
    }

    public ObjectSearchFilter getReceiptPrintStateSearch() {
        return this.receiptPrintStateSearch;
    }

    public void setAuthCode(String authCode) {
        this.eftposReferenceSearch.setObject(authCode);
    }

    public RangeJoinSearchFilter getPayOffDayFilter() {
        return this.payOffDaySearch;
    }
}

