/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.AdjustmentsTotalReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class AdjustmentsTotalSearcher
extends PropertySearcher<AdjustmentsTotalReport> {
    private IRangedQuerySearchFilter<Date> tradingDayDayFilter;
    private boolean groupByDayPart;
    private MultiOptionSearchFilter salesLocationFilter;

    public AdjustmentsTotalSearcher() {
        super(AdjustmentsTotalReport.class);
        this.tradingDayDayFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE);
        this.addSearchFilter(new TradingDayDateRangeFilterAdapter(this.tradingDayDayFilter));
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(SalesPriceAdjustment.Properties.ID).select(SalesPriceAdjustment.Properties.TRADING_DAY).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT).selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT', saved_total_value, 0)) as discounts").selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE', saved_total_value, 0)) as surcharges").groupBy(SalesPriceAdjustment.Properties.TRADING_DAY);
        if (this.tradingDayDayFilter.hasSearchValue()) {
            query.linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY);
        }
        if (this.groupByDayPart || this.salesLocationFilter.hasSearchValue()) {
            query.linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM);
            this.salesLocationFilter.addQueryRestriction(query);
        }
        if (this.groupByDayPart) {
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
            query.groupBy("fk_config_day_part");
        } else {
            query.selectFunc("null as fk_config_day_part");
        }
        return query;
    }

    public IRangedQuerySearchFilter<Date> getDateFilter() {
        return this.tradingDayDayFilter;
    }

    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public void setGroupByDayPart(boolean value) {
        this.groupByDayPart = value;
    }
}

