/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Collection;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.PreProdConsumeUsage;

public class PreProdConsumeUsageSearcher
extends PropertySearcher<PreProdConsumeUsage> {
    private final RangeQuerySearchFilter<Date> createDateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final ISingleValueSearchFilter<StockArea> stockAreaFilter;
    private final MultiOptionSearchFilter userFilter;
    private final ObjectJoinSearchFilter<Collection<StockGroup>> stockGroupFilter;

    public PreProdConsumeUsageSearcher() {
        super(PreProdConsumeUsage.class);
        this.createDateRangeFilter = new OptimisedDateRangeSearchFilter(PreProdConsumeUsage.Properties.CREATION_DATE, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.createDateRangeFilter);
        this.stockAreaFilter = new ObjectSearchFilter<StockArea>(PreProdConsumeUsage.Properties.STOCK_AREA);
        this.userFilter = new MultiOptionSearchFilter(PreProdConsumeUsage.Properties.USER);
        this.stockGroupFilter = new ObjectJoinSearchFilter<StockGroup>(new MultiOptionSearchFilter<StockGroup>(StockItem.Properties.STOCK_GROUP), PreProdConsumeUsage.Properties.STOCK_ITEM, StockItem.Properties.STOCK_GROUP);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.stockAreaFilter);
        this.addSearchFilter(this.userFilter);
        this.addSearchFilter(this.stockGroupFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(PreProdConsumeUsage.class).active(PreProdConsumeUsage.class);
    }

    public RangeQuerySearchFilter<Date> getCreationDateRangeFilter() {
        return this.createDateRangeFilter;
    }

    public ISingleValueSearchFilter<StockArea> getStockAreaFilter() {
        return this.stockAreaFilter;
    }

    public MultiOptionSearchFilter getUserFilter() {
        return this.userFilter;
    }

    public ObjectJoinSearchFilter<Collection<StockGroup>> getStockGroupFilter() {
        return this.stockGroupFilter;
    }
}

