/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Arrays;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class StockInventoryUsageLinkSearcher
extends DefaultPropertySearcher {
    private static final int DEFAULT_LIMIT = 3000;
    private final RangeQuerySearchFilter quantityRangeSearch;
    private final ObjectJoinSearchFilter activeSearch;
    private final ObjectJoinSearchFilter stockItemSearch;
    private final ObjectJoinSearchFilter inventoryItemUnitSearch;
    private final ObjectJoinSearchFilter stockGroupSearch;
    private final ObjectSearchFilter liquorfileIdSearch;
    private final ObjectJoinSearchFilter areaSearch;
    private final ObjectJoinSearchFilter stockableAreaSearch;
    private final ObjectJoinSearchFilter profileSearch;
    private final List ALL_FILTERS;

    public StockInventoryUsageLinkSearcher() {
        this(3000);
    }

    public StockInventoryUsageLinkSearcher(int limitNum) {
        super(StockInventoryUsageLink.class);
        this.quantityRangeSearch = new RangeQuerySearchFilter(StockInventoryUsageLink.Properties.QUANTITY);
        this.activeSearch = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT}, new ObjectSearchFilter(InventoryItemUnit.Properties.SYSTEM_STATE));
        this.stockItemSearch = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.STOCK_ITEM}, new TextSearchFilter(StockItem.Properties.LABEL));
        this.inventoryItemUnitSearch = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ITEM}, new TextSearchFilter(InventoryItem.Properties.LABEL));
        this.stockGroupSearch = new ObjectJoinSearchFilter<StockGroup>(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.STOCK_ITEM}, new ObjectSearchFilter<StockGroup>(StockItem.Properties.STOCK_GROUP));
        this.liquorfileIdSearch = new ObjectSearchFilter(StockInventoryUsageLink.Properties.LIQUORFILE_ID);
        this.areaSearch = new ObjectJoinSearchFilter<StockArea>(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.STOCK_ITEM, StockItem.Properties.STOCK_ON_HAND}, new ObjectSearchFilter<StockArea>(StockOnHand.Properties.STOCK_AREA));
        this.stockableAreaSearch = new ObjectJoinSearchFilter(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.STOCK_ITEM, StockItem.Properties.STOCK_ON_HAND}, new ObjectSearchFilter(StockOnHand.Properties.STOCK_ALLOWED));
        this.profileSearch = new ObjectJoinSearchFilter<InventoryProfile>(new PropertiedObject.Property[]{StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.MENU_GROUP}, new ObjectSearchFilter<InventoryProfile>(InventoryGroup.Properties.PROFILE));
        this.ALL_FILTERS = Arrays.asList(this.activeSearch, this.quantityRangeSearch, this.stockItemSearch, this.inventoryItemUnitSearch, this.liquorfileIdSearch, this.stockGroupSearch, this.areaSearch, this.stockableAreaSearch, this.profileSearch);
        this.setLimit(limitNum);
        this.setSearchFilters(this.ALL_FILTERS);
    }

    public void setActiveSearchOn(boolean value) {
        if (value) {
            this.activeSearch.setSearchValue("ACTIVE");
        } else {
            this.activeSearch.setSearchValue(null);
        }
    }

    public void setQuantitySearchRange(Integer from, Integer to) {
        this.quantityRangeSearch.setStart(from);
        this.quantityRangeSearch.setEnd(to);
    }

    public RangeQuerySearchFilter getQuantityRangeSearch() {
        return this.quantityRangeSearch;
    }

    public void setStockItemSearchPrefix(String value) {
        this.stockItemSearch.setSearchValue(value);
    }

    public ObjectJoinSearchFilter getStockItemSearch() {
        return this.stockItemSearch;
    }

    public void setInventoryItemUnitSearchPrefix(String value) {
        this.inventoryItemUnitSearch.setSearchValue(value);
    }

    public ObjectJoinSearchFilter getInventoryItemUnitSearch() {
        return this.inventoryItemUnitSearch;
    }

    public ObjectJoinSearchFilter getStockGroupSearch() {
        return this.stockGroupSearch;
    }

    public ObjectSearchFilter getLiquorfileIdSearch() {
        return this.liquorfileIdSearch;
    }

    public ObjectJoinSearchFilter getAreaSearch() {
        return this.areaSearch;
    }

    public ObjectJoinSearchFilter getStockableAreaSearch() {
        return this.stockableAreaSearch;
    }

    public ObjectJoinSearchFilter getProfileSearch() {
        return this.profileSearch;
    }

    @Override
    public ObjectQuery getBaseQuery() {
        return super.getBaseQuery().orderBy(StockInventoryUsageLink.Properties.ID);
    }
}

