/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock;

import au.com.ordermate.glazedlists.ChangeableMatcherEditor;
import au.com.ordermate.glazedlists.CountedPrefixComparator;
import au.com.ordermate.glazedlists.DefaultTermPrefixMatcher;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.glazedlists.StringComparator;
import au.com.ordermate.glazedlists.TermPrefixMatcher;
import au.com.ordermate.glazedlists.TreeNodeComparator;
import au.com.ordermate.util.DisplayableStringifier;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.CompositeMatcherEditor;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.List;
import javax.swing.tree.TreeNode;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;

public class StockItemSearcher {
    private CompositeMatcherEditor<StockItem> compositeEditor;
    private TermPrefixMatcher<StockItem> prefixMatcher;
    private ChangeableMatcherEditor<StockItem> prefixEditor;
    private TextMatcherEditor<StockItem> textEditor;
    private TextFilterator<StockItem> inventoryItemLabelFilterator;
    private SequentialComparator<StockItem> masterComparator;
    private CountedPrefixComparator<StockItem> prefixComp;
    private TreeNodeComparator<StockItem> groupComp;
    private StringComparator<StockItem> labelComp;
    private SortedList<StockItem> sortedItems;
    private FilterList<StockItem> filteredItems;

    public StockItemSearcher() {
        this.setupLists();
    }

    private void setupLists() {
        this.setupFilters();
        this.setupSorters();
    }

    private void setupFilters() {
        this.inventoryItemLabelFilterator = new TextFilterator<StockItem>(){

            public void getFilterStrings(List<String> addTo, StockItem item) {
                addTo.add(item.getLabel());
            }
        };
        this.textEditor = new TextMatcherEditor(this.inventoryItemLabelFilterator);
        this.prefixMatcher = new DefaultTermPrefixMatcher<StockItem>(new DisplayableStringifier());
        this.prefixEditor = new ChangeableMatcherEditor<StockItem>(this.prefixMatcher);
        BasicEventList matchersList = new BasicEventList();
        matchersList.add(this.textEditor);
        matchersList.add(this.prefixEditor);
        this.compositeEditor = new CompositeMatcherEditor((EventList)matchersList);
        this.compositeEditor.setMode(24);
    }

    private void setupSorters() {
        this.masterComparator = new SequentialComparator();
        this.groupComp = new TreeNodeComparator<StockItem>(){

            @Override
            protected TreeNode extractNode(Object value) {
                return ((StockItem)value).getStockGroup();
            }
        };
        this.prefixComp = new CountedPrefixComparator();
        this.labelComp = new StringComparator();
        this.masterComparator.addComparator(this.prefixComp);
        this.masterComparator.addComparator(this.groupComp);
        this.masterComparator.addComparator(this.labelComp);
    }

    public void setSearchString(String value) {
        this.prefixMatcher.setPrefixString(value);
        this.textEditor.setFilterText(value.split(" "));
        this.prefixEditor.matcherChanged();
        this.prefixComp.setSearchString(value);
        this.sortedItems.setComparator(this.masterComparator);
    }

    public EventList getResultingItems() {
        return this.sortedItems;
    }

    public boolean isRestricted() {
        return this.prefixMatcher.getPrefixStringsToMatch().length != 0;
    }

    public void setSearchParameters(List<StockItem> items, String prefGroup) {
        this.filteredItems = new FilterList(GlazedLists.eventList(items), this.compositeEditor);
        StockGroup groupToSearchBy = StockGroup.getStockGroupForName(prefGroup);
        this.groupComp.setTreeNode(groupToSearchBy);
        this.sortedItems = new SortedList(this.filteredItems, this.masterComparator);
    }

    public void addMatcherEditorListener(MatcherEditor.Listener listener) {
        this.compositeEditor.addMatcherEditorListener(listener);
    }

    public int getResultCount() {
        return this.filteredItems.size();
    }
}

