/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.adjustment;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.sql.queries.SelectQuery;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.stock.adjustment.StockAdjustmentReportQuery;
import ordermate.database.searchers.ArrayObjectSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.users.User;

public class StockAdjustmentSearcher
extends ArrayObjectSearcher {
    private final ISingleValueSearchFilter<StockArea> stockAreaFilter = new ObjectSearchFilter<StockArea>(null);
    private final ISingleValueSearchFilter<User> userSearchFilter = new ObjectSearchFilter<User>(null);
    private final ISingleValueSearchFilter<StockGroup> stockGroupSearchFilter = new ObjectSearchFilter<StockGroup>(null);
    private DateRangeSearchFilter dateFilter = new DateRangeSearchFilter(null, SQLDateType.TIMESTAMP);

    @FilterConfig(name="Stock Group", dataType=StockGroup.class, plural=FilterConfig.Plural.Single, nullAllowed=true, sequence=4)
    public ISingleValueSearchFilter<StockGroup> getStockGroupFilter() {
        return this.stockGroupSearchFilter;
    }

    @FilterConfig(name="Stock Area", dataType=StockArea.class, plural=FilterConfig.Plural.Single, nullAllowed=true, sequence=3)
    public ISingleValueSearchFilter<StockArea> getStockAreaFilter() {
        return this.stockAreaFilter;
    }

    @FilterConfig(name="User", dataType=User.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public ISingleValueSearchFilter<User> getUserSearchFilter() {
        return this.userSearchFilter;
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateFilter;
    }

    public SelectQuery getQuery() {
        SelectQuery query = StockAdjustmentReportQuery.doQuery();
        this.applyFilters(query);
        return query;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        return new ObjectQuerySQLAdapter(this.getQuery().getSQL());
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList(StockAdjustmentReportQuery.displayColumns);
    }

    private void applyFilters(SelectQuery query) {
        if (this.stockAreaFilter.hasSearchValue()) {
            query.addWhere("stock_usage.FK_stock_area = " + this.stockAreaFilter.getSearchValue().getID());
        }
        if (this.userSearchFilter.hasSearchValue()) {
            query.addWhere("stock_usage.FK_config_user = " + this.userSearchFilter.getSearchValue().getID());
        }
        if (this.stockGroupSearchFilter.hasSearchValue()) {
            List<StockGroup> allChildren = this.stockGroupSearchFilter.getSearchValue().getRecursiveSubGroups();
            String[] conditions = new String[allChildren.size() + 1];
            conditions[0] = "stock_item.FK_stock_group = " + this.stockGroupSearchFilter.getSearchValue().getID();
            for (int i = 0; i < allChildren.size(); ++i) {
                StockGroup child = allChildren.get(i);
                conditions[i + 1] = "stock_item.FK_stock_group = " + child.getID();
            }
            query.addWhereOr(conditions);
        }
        Timestamp sqlFrom = new Timestamp(((Date)this.dateFilter.getStart()).getTime());
        Timestamp sqlTo = new Timestamp(((Date)this.dateFilter.getEnd()).getTime());
        query.addWhere("stock_usage.UsageDate > '" + sqlFrom + "'");
        query.addWhere("stock_usage.UsageDate < '" + sqlTo + "'");
    }
}

