/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.liquorfile;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import ordermate.database.stock.liquorfile.PriceBookCategory;
import ordermate.database.stock.liquorfile.PriceBookDepartment;
import ordermate.database.stock.liquorfile.PriceBookGroup;
import ordermate.database.stock.liquorfile.PriceBookProduct;

public class PriceBookProductSearcher
extends PropertySearcher<PriceBookProduct> {
    private final TextSearchFilter descriptionSearchFilter;
    private final ObjectSearchFilter<PriceBookDepartment> deptSearchFilter;
    private final ObjectSearchFilter<PriceBookGroup> groupSearchFilter;
    private final ObjectSearchFilter<PriceBookCategory> catSearchFilter;

    public PriceBookProductSearcher(Class<PriceBookProduct> persistentObjClass) {
        super(persistentObjClass);
        this.descriptionSearchFilter = new TextSearchFilter(PriceBookProduct.Properties.DESCRIPTION);
        this.deptSearchFilter = new ObjectSearchFilter<PriceBookDepartment>(PriceBookProduct.Properties.PRICEBOOK_DEPARTMENT);
        this.groupSearchFilter = new ObjectSearchFilter<PriceBookGroup>(PriceBookProduct.Properties.PRICEBOOK_GROUP);
        this.catSearchFilter = new ObjectSearchFilter<PriceBookCategory>(PriceBookProduct.Properties.PRICEBOOK_CATEGORY);
        this.addSearchFilter(this.descriptionSearchFilter);
        this.addSearchFilter(this.deptSearchFilter);
        this.addSearchFilter(this.groupSearchFilter);
        this.addSearchFilter(this.catSearchFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return new ObjectQuery().select(PriceBookProduct.class).orderBy(PriceBookProduct.Properties.DESCRIPTION).limit(100);
    }

    public TextSearchFilter getDescriptionSearchFilter() {
        return this.descriptionSearchFilter;
    }

    public ObjectSearchFilter<PriceBookDepartment> getDeptSearchFilter() {
        return this.deptSearchFilter;
    }

    public ObjectSearchFilter<PriceBookGroup> getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public ObjectSearchFilter<PriceBookCategory> getCatSearchFilter() {
        return this.catSearchFilter;
    }
}

