/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.liquorfile;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.misc.TradingDay;
import ordermate.integration.liquorfile.scandata.ScandataTradingDayExport;

public class ScandataTradingDayExportSearcher
extends DefaultPropertySearcher<ScandataTradingDayExport> {
    private RangeJoinSearchFilter dateFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private boolean orderByDate;
    private static final int DEFAULT_LIMIT = 100;

    public ScandataTradingDayExportSearcher() {
        this(100);
    }

    public ScandataTradingDayExportSearcher(int limitNum) {
        super(ScandataTradingDayExport.class);
        this.dateFilter = new RangeJoinSearchFilter<Date>(new PropertiedObject.Property[]{ScandataTradingDayExport.Properties.TRADING_DAY}, new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE));
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateFilter);
        this.orderByDate = true;
        this.setLimit(limitNum);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
    }

    public void setDateRange(Date startDate, Date endDate) {
        this.dateFilter.setStart(startDate);
        this.dateFilter.setEnd(endDate);
    }

    public RangeJoinSearchFilter getDateFilter() {
        return this.dateFilter;
    }

    public void setOrderByDate(boolean value) {
        this.orderByDate = value;
    }

    public boolean isOrderByDate() {
        return this.orderByDate;
    }

    @Override
    public ObjectQuery getBaseQuery() {
        if (this.orderByDate) {
            return Query.select(ScandataTradingDayExport.class).orderByDesc(TradingDay.Properties.DATE);
        }
        return super.getBaseQuery();
    }
}

