/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.stocktake;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.config.Quantity;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;

public class StockEntryAggregate
extends StockTakeEntry {
    public static Props Properties = new Props();
    public static final String AGG_LABEL = "N/A";
    private List<StockTakeEntry> entries;
    private Quantity exQty;
    private Quantity acQty;
    private Quantity varQty;
    private Price exValue;
    private Price acValue;
    private Price acValueEx;
    private Price varValue;
    private Price varValueEx;
    private StockTakeAggregateType aggType;
    private static StockArea aggArea = new StockArea();
    private static StockGroup aggGroup;
    private StockItem aggItem;

    public StockEntryAggregate(StockTakeAggregateType yourType, StockTakeEntry yourEntry) {
        this.aggType = yourType;
        this.entries = new ArrayList<StockTakeEntry>();
        this.entries.add(yourEntry);
        this.setRawExpectedQty(yourEntry.getRawExpectedQty());
        this.setRawActualQty(yourEntry.getRawActualQty());
        this.setOuterQty(yourEntry.getOuterQty());
        this.setUnitQty(yourEntry.getUnitQty());
        if (!StockTakeAggregateType.Item.equals((Object)this.aggType)) {
            this.aggItem = yourEntry.getStockItem().clone();
            this.aggItem.setLabel(AGG_LABEL);
            if (StockTakeAggregateType.Area.equals((Object)this.aggType)) {
                this.aggItem.setStockGroup(aggGroup);
            } else {
                this.aggItem.setStockGroup(yourEntry.getStockItem().getStockGroup());
            }
        } else {
            this.setStockItem(yourEntry.getStockItem());
        }
    }

    @Override
    public Long getID() {
        return this.entries.get(0).getID();
    }

    private Quantity addQuantities(PropertiedObject.Property<Quantity> prop) {
        Quantity prototype = null;
        double value = 0.0;
        for (StockTakeEntry entry : this.entries) {
            Quantity qty = entry.getPropertyValue(prop);
            if (qty == null) continue;
            if (prototype == null) {
                prototype = qty;
                value = prototype.getRawValue();
                continue;
            }
            value += qty.getRawValue();
        }
        if (prototype != null) {
            return new Quantity(prototype.getMeasureUnit(), prototype.getQtyPerContainer(), prototype.getMeasureContainer(), value, true);
        }
        return null;
    }

    private Price addPrices(PropertiedObject.Property<Price> prop) {
        double value = 0.0;
        for (StockTakeEntry entry : this.entries) {
            Price price = entry.getPropertyValue(prop);
            if (price == null) continue;
            value += price.doubleValue();
        }
        return new Price(value, 0.01);
    }

    @Override
    public Quantity getExpectedQuantity() {
        if (this.exQty == null) {
            this.exQty = this.addQuantities(StockTakeEntry.Properties.EXPECTED_QUANTITY);
        }
        return this.exQty;
    }

    @Override
    public Quantity getActualQuantity() {
        if (this.acQty == null) {
            this.acQty = this.addQuantities(StockTakeEntry.Properties.ACTUAL_QUANTITY);
        }
        return this.acQty;
    }

    @Override
    public Price getTotalExpectedValue() {
        if (this.exValue == null) {
            this.exValue = this.addPrices(StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX);
        }
        return this.exValue;
    }

    @Override
    public Price getValuationValue() {
        if (this.acValue == null) {
            this.acValue = this.addPrices(StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE);
        }
        return this.acValue;
    }

    @Override
    public Price getValuationValueEx() {
        if (this.acValueEx == null) {
            this.acValueEx = this.addPrices(StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX);
        }
        return this.acValueEx;
    }

    @Override
    public Quantity getVariance() {
        if (this.varQty == null) {
            this.varQty = this.addQuantities(StockTakeEntry.Properties.VARIANCE);
        }
        return this.varQty;
    }

    @Override
    public Price getVarianceValue() {
        if (this.varValue == null) {
            this.varValue = this.addPrices(StockTakeEntry.Properties.VARIANCE_COST);
        }
        return this.varValue;
    }

    @Override
    public Price getVarianceValueEx() {
        if (this.varValueEx == null) {
            this.varValueEx = this.addPrices(StockTakeEntry.Properties.VARIANCE_COST_EX);
        }
        return this.varValueEx;
    }

    @Override
    public StockGroup getStockGroup() {
        return this.entries.get(0).getStockGroup();
    }

    @Override
    public StockItem getStockItem() {
        if (this.aggType.equals((Object)StockTakeAggregateType.Item)) {
            return this.entries.get(0).getStockItem();
        }
        return this.aggItem;
    }

    @Override
    public StockArea getStockArea() {
        if (this.aggType.equals((Object)StockTakeAggregateType.Area) || this.aggType.equals((Object)StockTakeAggregateType.GroupAndArea)) {
            return this.entries.get(0).getStockArea();
        }
        return aggArea;
    }

    @Override
    public StockTake getStockTake() {
        return this.entries.get(0).getStockTake();
    }

    public void addStockTakeEntry(StockTakeEntry toAdd) {
        this.entries.add(toAdd);
        this.setRawExpectedQty(toAdd.getRawExpectedQty() + this.getRawExpectedQty());
        this.setOuterQty(this.mash(this.getOuterQty(), toAdd.getOuterQty()));
        this.setUnitQty(this.mash(this.getUnitQty(), toAdd.getUnitQty()));
        this.exQty = null;
        this.acQty = null;
        this.varQty = null;
        this.exValue = null;
        this.acValue = null;
        this.acValueEx = null;
        this.varValue = null;
        this.varValueEx = null;
    }

    private Double mash(Double thisQ, Double thatQ) {
        Double q = null;
        if (thisQ == null) {
            if (thatQ != null) {
                q = thatQ;
            }
        } else {
            q = thatQ == null ? thisQ : Double.valueOf(thisQ + thatQ);
        }
        return q;
    }

    @Override
    public void saveChild() {
        throw new IllegalStateException("Cannot call save on an aggregated stocktake entry");
    }

    @Override
    public void deleteChild() {
        throw new IllegalStateException("Cannot call delete on an aggregated stocktake entry");
    }

    static {
        aggArea.setLabel(AGG_LABEL);
        aggGroup = new StockGroup();
        aggGroup.setLabel(AGG_LABEL);
    }

    public static class Props
    extends StockTakeEntry.Props {
    }
}

