/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.stocktake;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.database.searchers.stock.stocktake.StockEntryAggregate;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.stock.StockTakeEntry;
import org.apache.commons.collections.map.MultiKeyMap;

class StockTakeEntryAggregator {
    private StockTakeAggregateType aggregateTo = StockTakeAggregateType.None;

    StockTakeEntryAggregator() {
    }

    public void setAggregateType(StockTakeAggregateType newType) {
        this.aggregateTo = newType;
    }

    public List<StockTakeEntry> aggregate(List<StockTakeEntry> entries) {
        if (this.aggregateTo == null || StockTakeAggregateType.None.equals((Object)this.aggregateTo)) {
            return entries;
        }
        if (StockTakeAggregateType.Item.equals((Object)this.aggregateTo)) {
            return this.doBy(entries, StockTakeEntry.Properties.STOCK_ITEM);
        }
        if (StockTakeAggregateType.Area.equals((Object)this.aggregateTo)) {
            return this.doBy(entries, StockTakeEntry.Properties.STOCK_AREA);
        }
        if (StockTakeAggregateType.Group.equals((Object)this.aggregateTo)) {
            return this.doBy(entries, StockTakeEntry.Properties.STOCK_GROUP);
        }
        if (StockTakeAggregateType.GroupAndArea.equals((Object)this.aggregateTo)) {
            return this.doMultiBy(entries, StockTakeEntry.Properties.STOCK_GROUP, StockTakeEntry.Properties.STOCK_AREA);
        }
        throw new IllegalStateException("Unknown Aggregation type " + (Object)((Object)this.aggregateTo));
    }

    private List<StockTakeEntry> doBy(List<StockTakeEntry> entries, PropertiedObject.Property prop) {
        LinkedHashMap areaMap = new LinkedHashMap();
        for (StockTakeEntry entry : entries) {
            Object key = entry.getPropertyValue(prop);
            if (!areaMap.containsKey(key)) {
                areaMap.put(key, new StockEntryAggregate(this.aggregateTo, entry));
                continue;
            }
            ((StockEntryAggregate)areaMap.get(key)).addStockTakeEntry(entry);
        }
        ArrayList<StockTakeEntry> aggies = new ArrayList<StockTakeEntry>(areaMap.size());
        aggies.addAll(areaMap.values());
        return aggies;
    }

    private List<StockTakeEntry> doMultiBy(List<StockTakeEntry> entries, PropertiedObject.Property prop1, PropertiedObject.Property prop2) {
        LinkedHashMap<Object, StockEntryAggregate> aggMap = new LinkedHashMap<Object, StockEntryAggregate>();
        MultiKeyMap keyMap = new MultiKeyMap();
        int count = 0;
        for (StockTakeEntry entry : entries) {
            Object key2;
            Object key1 = entry.getPropertyValue(prop1);
            Object key = keyMap.get(key1, key2 = entry.getPropertyValue(prop2));
            if (key == null) {
                key = count;
                ++count;
                keyMap.put(key1, key2, key);
                aggMap.put(key, new StockEntryAggregate(this.aggregateTo, entry));
                continue;
            }
            ((StockEntryAggregate)aggMap.get(key)).addStockTakeEntry(entry);
        }
        ArrayList<StockTakeEntry> aggies = new ArrayList<StockTakeEntry>(aggMap.size());
        aggies.addAll(aggMap.values());
        return aggies;
    }
}

