/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.stock.stocktake;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.searchers.stock.stocktake.StockTakeEntryAggregator;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;

public class StockTakeSearcher
extends DefaultPropertySearcher<StockTakeEntry> {
    private final ISingleValueSearchFilter<StockTake> stockTakeSearch;
    private final ISingleValueSearchFilter<Collection<StockGroup>> stockGroupSearch;
    private final ISingleValueSearchFilter<StockArea> stockAreaSearch;
    private final BooleanSearchFilter notRecordedSearch;
    private final BooleanSearchFilter recordedSearch;
    private final BooleanSearchFilter varianceSearch;
    private StockTakeAggregateType aggregation;

    public StockTakeSearcher() {
        super(StockTakeEntry.class);
        this.stockTakeSearch = new ObjectSearchFilter<StockTake>(StockTakeEntry.Properties.STOCK_TAKE);
        this.stockGroupSearch = new ObjectJoinSearchFilter<StockGroup>(new PropertiedObject.Property[]{StockTakeEntry.Properties.STOCK_ITEM, StockItem.Properties.STOCK_GROUP}, new MultiOptionSearchFilter<StockGroup>(StockItem.Properties.STOCK_GROUP));
        this.stockAreaSearch = new ObjectSearchFilter<StockArea>(StockTakeEntry.Properties.STOCK_AREA);
        this.notRecordedSearch = new BooleanSearchFilter(null);
        this.recordedSearch = new BooleanSearchFilter(null);
        this.varianceSearch = new BooleanSearchFilter(null);
        this.addSearchFilter(this.stockTakeSearch);
        this.addSearchFilter(this.stockAreaSearch);
        this.addSearchFilter(this.stockGroupSearch);
    }

    @Override
    public ObjectQuery getBaseQuery() {
        return super.getBaseQuery().linkUsing(StockTakeEntry.Properties.STOCK_ITEM).linkUsing(StockTakeEntry.Properties.STOCK_AREA, StockOnHand.Properties.STOCK_AREA).linkUsing(StockTakeEntry.Properties.STOCK_ITEM, StockOnHand.Properties.STOCK_ITEM).linkUsing(StockItem.Properties.STOCK_GROUP, StockGroup.Properties.ID).whereFunction("stock_on_hand.system_state = 'ACTIVE'").group().not().equals(StockOnHand.Properties.STOCK_ALLOWED, false).or().not().equals(StockOnHand.Properties.QUANTITY, 0.0).endGroup().orderBy(StockGroup.Properties.LABEL).orderBy(StockItem.Properties.LABEL).orderBy(StockTakeEntry.Properties.ID);
    }

    @Override
    public List<StockTakeEntry> search() {
        ArrayList<StockTakeEntry> result = new ArrayList<StockTakeEntry>();
        List allEntries = super.search();
        for (StockTakeEntry entry : allEntries) {
            if (!this.isValidEntry(entry)) continue;
            result.add(entry);
        }
        return this.aggregate(result);
    }

    private boolean isValidEntry(StockTakeEntry entry) {
        boolean show = true;
        if (this.notRecordedSearch.hasSearchValue()) {
            show = entry.isNotRecorded();
        }
        if (this.recordedSearch.hasSearchValue()) {
            boolean bl = show = show && entry.isRecorded();
        }
        if (this.varianceSearch.hasSearchValue()) {
            show = show && entry.hasVariance();
        }
        return show;
    }

    @Override
    public ObjectQuery getObjectQuery() {
        return super.getObjectQuery();
    }

    @FilterConfig(name="Stock Group", dataType=StockGroup.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public ISingleValueSearchFilter<Collection<StockGroup>> getStockGroupSearch() {
        return this.stockGroupSearch;
    }

    @FilterConfig(name="Stock Take", dataType=StockTake.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public ISingleValueSearchFilter<StockTake> getStockTakeSearch() {
        return this.stockTakeSearch;
    }

    @FilterConfig(name="Stock Area", dataType=StockArea.class, plural=FilterConfig.Plural.Single, nullAllowed=true)
    public ISingleValueSearchFilter<StockArea> getStockAreaSearch() {
        return this.stockAreaSearch;
    }

    public BooleanSearchFilter getRecordedSearch() {
        return this.recordedSearch;
    }

    public BooleanSearchFilter getNotRecordedSearch() {
        return this.notRecordedSearch;
    }

    public BooleanSearchFilter getVarianceSearch() {
        return this.varianceSearch;
    }

    public void aggregateBy(StockTakeAggregateType selectedAggregation) {
        this.aggregation = selectedAggregation;
    }

    public StockTakeAggregateType getAggregation() {
        return this.aggregation;
    }

    private List<StockTakeEntry> aggregate(List<StockTakeEntry> entries) {
        StockTakeEntryAggregator aggy = new StockTakeEntryAggregator();
        aggy.setAggregateType(this.aggregation);
        return aggy.aggregate(entries);
    }
}

