/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.unknown;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.BooleanQueryFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.unknown.SalesUnknown;
import ordermate.database.sales.unknown.SalesUnknownType;

public class SalesUnknownSearcher
extends PropertySearcher<SalesUnknown> {
    private final ISingleValueSearchFilter labelFilter;
    private final ISingleValueSearchFilter typeFilter;
    private final ISingleValueSearchFilter sourceFilter;
    private final BooleanSearchFilter linkedFilter;
    private final BooleanQueryFilter syncedFilter;

    public SalesUnknownSearcher() {
        super(SalesUnknown.class);
        this.labelFilter = new TextSearchFilter(SalesUnknown.Properties.LABEL, TextSearchFilter.TextSearchStrategy.Like);
        this.typeFilter = new MultiOptionSearchFilter<SalesUnknownType>(SalesUnknown.Properties.TYPE);
        this.sourceFilter = new TextSearchFilter(SalesUnknown.Properties.SOURCE);
        this.linkedFilter = new BooleanSearchFilter(SalesUnknown.Properties.LINKED);
        this.syncedFilter = new BooleanQueryFilter(SalesUnknown.Properties.SYNCED);
        this.addSearchFilter(this.labelFilter);
        this.addSearchFilter(this.typeFilter);
        this.addSearchFilter(this.linkedFilter);
        this.addSearchFilter(this.syncedFilter);
        this.addSearchFilter(this.sourceFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(SalesUnknown.class);
    }

    @Override
    public List<SalesUnknown> search() {
        List<SalesUnknown> results = super.search();
        if (this.linkedFilter.hasSearchValue()) {
            ArrayList<SalesUnknown> filteredResults = new ArrayList<SalesUnknown>();
            boolean searchValue = (Boolean)this.linkedFilter.getSearchValue();
            for (SalesUnknown result : results) {
                if (result.isLinked() != searchValue) continue;
                filteredResults.add(result);
            }
            return filteredResults;
        }
        return results;
    }

    public ISingleValueSearchFilter getLabelFilter() {
        return this.labelFilter;
    }

    public ISingleValueSearchFilter getTypeFilter() {
        return this.typeFilter;
    }

    public BooleanSearchFilter getLinkedFilter() {
        return this.linkedFilter;
    }

    public ISingleValueSearchFilter<Boolean> getSyncFilter() {
        return this.syncedFilter;
    }

    public ISingleValueSearchFilter<String> getSourceFilter() {
        return this.sourceFilter;
    }
}

