/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.searchers.users;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.implementation.TextSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.implementation.BooleanEventListFilter;
import ordermate.database.users.User;

public class UserSearcher<T extends User>
extends PropertySearcher<T> {
    private ISingleValueSearchFilter firstNameFilter;
    private ISingleValueSearchFilter lastNameFilter;
    private ISingleValueSearchFilter permissionGroupFilter;

    public UserSearcher(Class<T> searchClass) {
        super(searchClass);
        this.firstNameFilter = new TextSearchFilter(User.Properties.FIRST_NAME);
        this.lastNameFilter = new TextSearchFilter(User.Properties.LAST_NAME);
        this.permissionGroupFilter = new BooleanEventListFilter(User.Properties.PERMISSION_GROUP);
        this.addSearchFilter(this.firstNameFilter);
        this.addSearchFilter(this.lastNameFilter);
        this.addSearchFilter(this.permissionGroupFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(this.getPersistentClass()).active(User.class).equals(User.Properties.HIDDEN, false).active(User.class);
    }

    public ISingleValueSearchFilter getFirstNameFilter() {
        return this.firstNameFilter;
    }

    public ISingleValueSearchFilter getLastNameFilter() {
        return this.lastNameFilter;
    }

    public ISingleValueSearchFilter getPermissionGroupFilter() {
        return this.permissionGroupFilter;
    }
}

