/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.stock;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.ButtonInfo;
import ordermate.database.Data;
import ordermate.database.config.Quantity;

public class CachedStockTakeEntry
extends ButtonInfo
implements Comparable<CachedStockTakeEntry> {
    private Quantity theoretical;
    private Quantity actual;
    private Quantity original;
    private boolean checked;
    private List<String> existingBarcodes;
    private List<String> newBarcodes;
    private long stockItemID;

    public CachedStockTakeEntry(long newID, String newLabel, Quantity theoreticalQty, Quantity actualQty, long newStockItemID, List<String> barcodes) {
        super(newID, newLabel);
        this.theoretical = theoreticalQty;
        this.actual = actualQty;
        this.existingBarcodes = barcodes;
        this.stockItemID = newStockItemID;
        this.newBarcodes = new ArrayList<String>();
        this.checked = actualQty != null;
        this.original = actualQty == null ? null : new Quantity(actualQty);
    }

    public Quantity getTheoreticalQuantity() {
        return this.theoretical;
    }

    public Quantity getActualQuantity() {
        return this.actual;
    }

    public void setActualQuantity(Quantity actualQty) {
        if (actualQty == null) {
            this.actual = null;
            this.checked = false;
        } else {
            this.actual = actualQty;
            this.checked = true;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean newChecked) {
        if (this.checked && this.actual == null) {
            this.actual = new Quantity(this.theoretical);
        }
        this.checked = newChecked;
    }

    public boolean hasBarcode(String barcode) {
        String bCode;
        boolean found = false;
        Iterator<String> iterator = this.existingBarcodes.iterator();
        while (iterator.hasNext() && !found) {
            bCode = iterator.next();
            if (!bCode.equals(barcode)) continue;
            found = true;
        }
        iterator = this.newBarcodes.iterator();
        while (iterator.hasNext() && !found) {
            bCode = iterator.next();
            if (!bCode.equals(barcode)) continue;
            found = true;
        }
        return found;
    }

    public void addBarcode(String barcode) {
        if (barcode == null) {
            throw new IllegalArgumentException("barcode cannot be null!");
        }
        if (!this.hasBarcode(barcode)) {
            this.newBarcodes.add(barcode);
        }
    }

    public boolean hasNewBarcodes() {
        return this.newBarcodes.size() != 0;
    }

    private void saveNewBarcodes() {
        Iterator<String> iterator = this.newBarcodes.iterator();
        while (iterator.hasNext()) {
            String barcode = null;
            try {
                barcode = iterator.next();
                Data.database.addStockItemBarcode(this.stockItemID, barcode);
                iterator.remove();
                this.existingBarcodes.add(barcode);
            }
            catch (RemoteException e) {
                OrderMate.LOG.warn("Exception saving barcode : " + barcode, (Throwable)e);
            }
        }
    }

    public boolean save() {
        if (this.hasNewBarcodes()) {
            this.saveNewBarcodes();
        }
        if (this.isChecked() && this.actual != null && (this.original == null || !this.original.equals(this.actual))) {
            try {
                Data.database.updateStockOnHand(this.getID(), this.actual);
                this.original = new Quantity(this.actual);
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Could not save entry.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(CachedStockTakeEntry obj) {
        return this.label.compareTo(obj.label);
    }

    public static List getStockTakeEntries(int stockTakeID, int stockAreaID, int stockGroupID) {
        List entries = new ArrayList();
        try {
            entries = Data.database.getStockTakeEntries(stockTakeID, stockAreaID, stockGroupID);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
        return entries;
    }
}

